//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

#ifndef mainH
#define mainH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Menus.hpp>
#include "WinScreenInterface.h"
#include "WinFileInterface.h"
#include "WinCommInterface.h"
#include "WinMainSetupInterface.h"
#include "WinPrinterInterface.h"
#include "Interpreter.h"
#include "WinKeyMap.h"
#include "KeyState.hpp"
#include "CPort.hpp"
#include <ActnList.hpp>
#include <AppEvnts.hpp>
#include <ExtCtrls.hpp>
#include "BmpFontLoader.hpp"
//---------------------------------------------------------------------------
class TMainWindow : public TForm
{
__published:	// IDE-managed Components
   TPopupMenu *SetupMenu;
   TMenuItem *popComPort;
   TMenuItem *popKeyboard;
   TMenuItem *FileTransfer1;
   TMenuItem *popExit;
   TMenuItem *popGeneral;
   TMenuItem *AutodialSetup1;
   TActionList *ActionList1;
   TAction *ShowMenu;
   TMenuItem *popConnect;
   TMenuItem *Help1;
   TMenuItem *popAbout;
   TMenuItem *popShowHelp;
   TMenuItem *popPrinter;
   TMenuItem *popScreen;
   TMenuItem *N1;
   TMenuItem *N2;
   TMenuItem *popAsciiTransfer;
   TApplicationEvents *ApplicationEvents1;
   TKeyState *KeyState1;
   TTimer *Timer1;
   TTimer *tmrPrinterCheck;
   TMenuItem *popPrinterSetup;
   TMenuItem *popPrinterRelease;
   TMenuItem *popPrinterNewPage;
   void __fastcall FormKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
   void __fastcall popExitClick(TObject *Sender);
   void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
   void __fastcall FormCreate(TObject *Sender);
   void __fastcall FormDestroy(TObject *Sender);
   void __fastcall popKeyboardClick(TObject *Sender);
   void __fastcall popGeneralClick(TObject *Sender);
   void __fastcall AutodialSetup1Click(TObject *Sender);
   void __fastcall ShowMenuExecute(TObject *Sender);
   void __fastcall popComPortClick(TObject *Sender);
   void __fastcall popConnectClick(TObject *Sender);
   void __fastcall popAboutClick(TObject *Sender);
   void __fastcall popScreenClick(TObject *Sender);
   void __fastcall popAsciiTransferClick(TObject *Sender);
   void __fastcall ApplicationEvents1Deactivate(TObject *Sender);
   void __fastcall ApplicationEvents1Activate(TObject *Sender);
   void __fastcall Timer1Timer(TObject *Sender);
   void __fastcall tmrPrinterCheckTimer(TObject *Sender);
   void __fastcall popPrinterSetupClick(TObject *Sender);
   void __fastcall popPrinterReleaseClick(TObject *Sender);
   void __fastcall popPrinterNewPageClick(TObject *Sender);
private:	// User declarations
   TBmpFontLoader *BmpFontLoader;
   AnsiString _configFile;
   AnsiString _debugFileName;
   WinPrinterInterface *_printer;
   WinCommInterface *_comPort;
   WtInterpreter *_interpreter;
   WinScreenInterface *_screen;
   WinFileInterface *_fInterface;
   WinKeyMap *_keyMap;
   WinMainSetupInterface *_setup;
   bool _comparing;
   WangFlowCtrl_t _lastWangFlowCtrl;
   bool _firstFocus;
   void _loadFonts(AnsiString fontDir);
   void _removeFonts(AnsiString fontDir);
   void _onComReceive(int count);
   void _onComOpen();
   void _onComClose(void);
   void _onCom80Full(void);
   void _updateCaption(void);
   void _dialNumber(AnsiString phoneNum);
   void __fastcall ScreenKeyDown(TObject *Sender, WORD &Key, TShiftState Shift);
public:		// User declarations
   __fastcall TMainWindow(TComponent* Owner);
    BEGIN_MESSAGE_MAP
        MESSAGE_HANDLER(WM_DISPLAYCHANGE, TMessage, ResolutionChange)
        MESSAGE_HANDLER(WM_SYSCOMMAND, TMessage, SysMenuRequest);
    END_MESSAGE_MAP(TForm)
    void __fastcall ResolutionChange(TMessage &Message);
    void __fastcall SysMenuRequest(TMessage &Message);
};
//---------------------------------------------------------------------------
extern PACKAGE TMainWindow *MainWindow;
//---------------------------------------------------------------------------
#endif
