//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <iostream>
#include <fstream>
#include <memory>
#include "main.h"
#include "TAboutForm.h"
#include "TAsciiDumpForm.h"
#include "AutoDialForm.h"
#include <sysutils.hpp>
#include <winbase.h>
#include <string.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "KeyState"
#pragma link "BmpFontLoader"
#pragma resource "*.dfm"
//---------------------------------------------------------------------------
#define FONT_FILES "*.FON"
#define FONT_DIR "fonts\\"
#define DEF_CAPTION "EMU Emulator (Press Ctrl+A for Menu) - "
#define CONFIG_FILE "emu.ini"
#define DEBUG_FILE "emu.log"
//---------------------------------------------------------------------------

TMainWindow *MainWindow;
//---------------------------------------------------------------------------
__fastcall TMainWindow::TMainWindow(TComponent* Owner)
   : TForm(Owner)
{
}

//---------------------------------------------------------------------------
void __fastcall TMainWindow::SysMenuRequest(TMessage &Message)
{
   // Disallow the System menu to be invoked by the keyboard
   if ((Message.WParam & 0xFFF0) == SC_KEYMENU)
      return;
   else
      TForm::Dispatch(&Message);
}

//---------------------------------------------------------------------------
void __fastcall TMainWindow::ShowMenuExecute(TObject *Sender)
{
   // Display the Menu
   // Since the Popup Y co-ordinate refers to the TOP of the menu list, we
   // need to calculate the approximate client-height of the menu. It's an
   // approximate because separators are not as high as normal menu items
   int menuHeight = GetSystemMetrics(SM_CYMENU) * SetupMenu->Items->Count;
   int capHeight = GetSystemMetrics(SM_CYCAPTION) + GetSystemMetrics(SM_CYEDGE);
   SetupMenu->Popup(Left + (ClientWidth/2),
     Top + capHeight + // Account for TitleBar height
     ((ClientHeight-menuHeight)/2));
}

//---------------------------------------------------------------------------
void __fastcall TMainWindow::FormKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   if (Key == VK_CAPITAL || Key == VK_SHIFT || Key == VK_CONTROL || Key == VK_MENU)
      {
      return;
      }
   shiftState_t sState;
   unsigned char outString[256];
   int length=256;
   bool keyIsAlpha = (Key >= 'A' && Key <= 'Z');
   bool capsLockOn = KeyState1->CapsLockOn;

   sState.shift = Shift.Contains(ssShift);
   sState.alt = Shift.Contains(ssAlt);
   sState.ctrl = Shift.Contains(ssCtrl);

   if ((!sState.shift && (!keyIsAlpha  || !capsLockOn)) ||
      (keyIsAlpha && capsLockOn && sState.shift))
      sState.shift = false;
   else
      sState.shift = true;
   _keyMap->getKeyCode((unsigned char)(Key), sState, outString, length);
   Key = 0; // Clear the key as we've handled it  //### Might not matter
   if (_comPort->isOpen())
      _comPort->write(outString, length);
}

//---------------------------------------------------------------------------
void __fastcall TMainWindow::popExitClick(TObject *Sender)
{
// Request that the main form be closed (attempt to close down the application)
Close();
}

//---------------------------------------------------------------------------
void __fastcall TMainWindow::ResolutionChange(TMessage &Message)
{
// This function is called when there is a change in the screen
// resolution, so that the correct font size may be loaded.

// See if this can be done at the component level
}

//---------------------------------------------------------------------------
void __fastcall TMainWindow::FormClose(TObject *Sender,
      TCloseAction &Action)
{
   if (_setup->confirmExit())
   {
      // Ask the user for confirmation to close the application
      int result = MessageDlg("Are you sure you want to exit?",
         mtConfirmation, TMsgDlgButtons() << mbYes << mbNo, 0);
      if (result == mrYes)
         Action = caFree;
      else
         Action = caNone;
   }
   else
      Action = caFree;
}
//---------------------------------------------------------------------------
void __fastcall TMainWindow::FormCreate(TObject *Sender)
{
   BmpFontLoader = new TBmpFontLoader(this);
   _firstFocus = true;
   // Read the main setup file
   _setup = new WinMainSetupInterface(this);
   _configFile = ExtractFilePath(Application->ExeName) + CONFIG_FILE;
   _debugFileName = ExtractFilePath(Application->ExeName) + DEBUG_FILE;
   _setup->loadSetup(_configFile.c_str());
   // Load the fonts
   _loadFonts(ExtractFilePath(Application->ExeName) + FONT_DIR);
   // Link the other components, screen, commport interpreter
   _interpreter = new WtInterpreter();
   _printer = new WinPrinterInterface(this);
   // Comm Port setup
   _comPort = new WinCommInterface(this);
   _comPort->onComReceive = &_onComReceive;
   _comPort->onComOpen = &_onComOpen;
   _comPort->onComClose = &_onComClose;
   _comPort->onCom80Full = &_onCom80Full;
   // Screen Setup
   _screen = new WinScreenInterface(this);
   // File handling interface
   _fInterface = new WinFileInterface();
   // KeyMap setup
   _keyMap = new WinKeyMap(this);
   string keyMapFile;
   _setup->keyMapFile(keyMapFile);
   _keyMap->loadSetup(keyMapFile);
   // Interpreter Setup
   _interpreter->setCommInterface(_comPort);
   _interpreter->setScreenInterface(_screen);
   _interpreter->setFileInterface(_fInterface);
   _interpreter->setPrinterInterface(_printer);
   // Read the setup/configuration files
   _screen->loadSetup(_configFile.c_str());
   ClientWidth = _screen->getPixelWidth();
   ClientHeight = _screen->getPixelHeight();
   _screen->redraw();
   _comPort->loadSetup(_configFile.c_str());
   _printer->loadSetup(_configFile.c_str());
   _updateCaption();
   tmrPrinterCheck->Enabled = true;
   _comparing = false;
   _lastWangFlowCtrl = _setup->wangFlowCtrl();
   // if connect on startup is true, then connect
   if (_setup->openOnStart())
   {
      _comPort->open();
      _updateCaption();
   }
   //Timer1->Enabled = true;
   //### Auto-dial hack
   if (_setup->_dialnum != "")
      _dialNumber(_setup->_dialnum);
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::FormDestroy(TObject *Sender)
{
   //if (_setup->capsOnFocus() || _setup->capsOnStart())
   //   KeyState1->CapsLockOn = false;
   _removeFonts(ExtractFilePath(Application->ExeName) + FONT_DIR);
   delete _interpreter;
   delete _comPort;
   delete _screen;
   delete _fInterface;
   delete _printer;
   delete _keyMap;
   delete _setup;
   delete BmpFontLoader;
}

//---------------------------------------------------------------------------
void TMainWindow::_loadFonts(AnsiString fontDir)
{
   if (BmpFontLoader->LoadFolder(fontDir) == 0)
      {
      MessageDlg("No font files were found in \r\n"+fontDir+
         "\r\nCharacters displayed on the screen may not display correctly!",
         mtWarning, TMsgDlgButtons() << mbOK, 0);
      }
}

//---------------------------------------------------------------------------
void TMainWindow::_removeFonts(AnsiString fontDir)
{
   BmpFontLoader->UnloadFolder(fontDir);
}

//---------------------------------------------------------------------------
bool matchstr(unsigned char *inBuff, int inBuffLen, char *cmpstr)
{
   static k=0;
   int foundPos=-1;

   for (int i=0; i<inBuffLen; i++)
   {
      if (inBuff[i] == cmpstr[k])
      {
         foundPos = i;
         break;
      }
   }

   if (foundPos == -1)
   {
      k = 0;
      return false;
   }
   int cmpstrlen = strlen(cmpstr);
   int a=foundPos;
   bool endbuff=false;
   bool matching=true;
   int i;
   for (i=k; i<cmpstrlen; i++, a++)
   {
      if (a == inBuffLen)
      {
      endbuff = true;
      break;
      }
      if (inBuff[a] != cmpstr[i])
      {
      matching=false;
      break;
      }
   }

   if ((i < cmpstrlen) && matching && endbuff)
   {
      // Continue the search next time we get more data
      k = i;
   }
   else if ((i == cmpstrlen) && matching)
   {
      // Found a match
      return true;
   }
   return false;
}

void TMainWindow::_onComReceive(int count)
{
   char *buffer = new unsigned char[count+1];

   _comPort->read(buffer, count);

   // Handle Auto-dial modem control and resetting the wang flow control
   if (_comparing)
   {
      if (matchstr(buffer, count, "CONNECT"))
      {
         // Restore the flow control
         _setup->setWangFlowCtrl(_lastWangFlowCtrl);
         _comparing = false;
      }
   }

   // Handle logging
   if (_setup->loggingOn())
      {
      buffer[count] = '\0';
      ofstream outfile(_debugFileName.c_str(), ios_base::app);
      outfile.write(buffer, count);
      }

   if (_setup->wangFlowCtrl() == wfcForce)
      _interpreter->setFlowOff();
   _interpreter->interpret(buffer, count);
   // Turn off flow control if necessary
   if (_interpreter->isFlowOff() &&
      _setup->wangFlowCtrl() == wfcDynamic ||
      _setup->wangFlowCtrl() == wfcForce)
      _interpreter->setFlowOn();

   delete [] buffer;
}

//---------------------------------------------------------------------------
void TMainWindow::_onComOpen()
{
   // Display the connection settings in the titlebar
   _updateCaption();
}

//---------------------------------------------------------------------------
void TMainWindow::_onComClose(void)
{
   // Update the connection settings in the titlebar
   _updateCaption();
}

//---------------------------------------------------------------------------
void TMainWindow::_onCom80Full(void)
{
   if (_setup->wangFlowCtrl() == wfcDynamic)
      _interpreter->setFlowOff();
}

//---------------------------------------------------------------------------
void TMainWindow::_updateCaption(void)
{
   // Update the connection settings in the titlebar
   char buffer[50];
   _comPort->getSetupString(buffer);
   Caption = DEF_CAPTION + AnsiString(buffer);
   if (_comPort->isOpen())
      popConnect->Caption = "Disconnect";
   else
      popConnect->Caption = "Connect";
}

//---------------------------------------------------------------------------
void __fastcall TMainWindow::popKeyboardClick(TObject *Sender)
{
   _keyMap->setup();
}

//---------------------------------------------------------------------------
void __fastcall TMainWindow::popGeneralClick(TObject *Sender)
{
   // Setup things like caps lock key handling etc.
   if (_setup->setup() == mrOk)
      {
      _setup->saveSetup(_configFile.c_str());
      }
}

void TMainWindow::_dialNumber(AnsiString phoneNum)
{
   AnsiString dialstr(phoneNum+"\x0D");

   //_setup->setWangFlowCtrl(_lastWangFlowCtrl);
   _lastWangFlowCtrl = _setup->wangFlowCtrl();
   _setup->setWangFlowCtrl(wfcNone);
   _comparing = true;
   _comPort->write(dialstr.c_str(), dialstr.Length());
}

//---------------------------------------------------------------------------
void __fastcall TMainWindow::AutodialSetup1Click(TObject *Sender)
{
   // Display an address-book style of screen
   auto_ptr<TfrmAutoDial> frmAutoDial (new TfrmAutoDial(this));

   frmAutoDial->setIniName(&_configFile);
   frmAutoDial->ReadSettings();
   if ((frmAutoDial->ShowModal() == mrOk) && frmAutoDial->chkDialNow->Checked)
   {
      // Dial the number now
      _dialNumber(frmAutoDial->edtPhoneNum->Text);
   } else {
      _setup->setWangFlowCtrl(_lastWangFlowCtrl);
      _comparing = false;
   }
}

//---------------------------------------------------------------------------
void __fastcall TMainWindow::popComPortClick(TObject *Sender)
{
   // Display the Com Port setup screen
   if (_comPort->setup() == mrOk)
   {
      _comPort->saveSetup(_configFile.c_str());
      _updateCaption();
   }
}
//---------------------------------------------------------------------------


void __fastcall TMainWindow::popConnectClick(TObject *Sender)
{
   // Toggle the Com Port's connection
   if (_comPort->isOpen())
      _comPort->close();
   else
      _comPort->open();
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::popAboutClick(TObject *Sender)
{
   // Display the About Form
   auto_ptr<TAboutForm> about (new TAboutForm(this));
   about->ShowModal();
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::popScreenClick(TObject *Sender)
{
   // Display the Screen setup screen
   if (_screen->setup() == mrOk)
      {
      _screen->saveSetup(_configFile.c_str());
      ClientWidth = _screen->getPixelWidth();
      ClientHeight = _screen->getPixelHeight();
      Position = poScreenCenter;
      _screen->redraw();
      }
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::popAsciiTransferClick(TObject *Sender)
{
   // ASCII File Transfer
   auto_ptr<TfrmAsciiDump> frmAsciiDump (new TfrmAsciiDump(this));

   frmAsciiDump->setCommInterface(_comPort);
   frmAsciiDump->setIniName(&_configFile);
   frmAsciiDump->ReadSettings();
   frmAsciiDump->ShowModal();
}
//---------------------------------------------------------------------------
void __fastcall TMainWindow::ApplicationEvents1Deactivate(TObject *Sender)
{
//   if (_setup->capsOnFocus())
//      KeyState1->CapsLockOn = false;
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::ApplicationEvents1Activate(TObject *Sender)
{
   if (_firstFocus)
      {
      _firstFocus = false;
      if (_setup->capsOnStart())
         KeyState1->CapsLockOn = true;
      }

//   if (_setup->capsOnFocus())
//      KeyState1->CapsLockOn = true;
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::Timer1Timer(TObject *Sender)
{
   _interpreter->setFlowOn();
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::tmrPrinterCheckTimer(TObject *Sender)
{
   // Check to see if we need to close the printer and end a print job
   _printer->checkTimeout(5);
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::popPrinterSetupClick(TObject *Sender)
{
   // Setup the Printer
   if (_printer->setup() == mrOk)
      _printer->saveSetup(_configFile.c_str());
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::popPrinterReleaseClick(TObject *Sender)
{
   _printer->close();
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::popPrinterNewPageClick(TObject *Sender)
{
   _printer->print('\x0C');
   _printer->close();
}
//---------------------------------------------------------------------------


