; Instructions for creating a new setup from this template script:
; * Change the MyAppName, MyAppShortName, MyAppMainExe and MyAppExeName defines to make them specific to the application
; * Change the AppID, SourceDir, AppMutex and LicenseFile settings
; * Modify the File section

#define MyAppName "Emu"
#define MyAppShortName "Emu"
#define MyAppMainExe "D:\projects\emu\win32\Emu.exe"
#define MyAppExeName "Emu.exe"
#define MyAppVersion() ParseVersion(MyAppMainExe, Local[0], Local[1], Local[2], Local[3]), Str(Local[0]) + "." + Str(Local[1]);
#define MyAppPublisher "Blue Leaf Concepts"
#define MyAppURL "http://www.blueleafconcepts.com/"
#define MyAppCopyright "Copyright  2001-2014, Blue Leaf Concepts"

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
AppID={{C577496E-E740-4AD7-ADE7-54814557E8A5}
AppName={#MyAppName}
AppVersion={#MyAppVersion}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
AppCopyright={#MyAppCopyright}
SourceDir=D:\projects\emu
DefaultDirName={pf}\{#MyAppPublisher}\{#MyAppName}
DefaultGroupName={#MyAppName}
AllowNoIcons=true
OutputDir=win32\deploy
OutputBaseFilename={#MyAppShortName}_{#MyAppVersion}_setup
Compression=lzma/Max
SolidCompression=true
AllowUNCPath=false
SignTool=SignTool
SignedUninstaller=yes
ShowLanguageDialog=no
;MinVersion=,5.1.2600
UninstallDisplayName={#MyAppName}
UninstallDisplayIcon={app}\{#MyAppExeName}
WizardImageFile="C:\Program Files (x86)\Inno Setup 5\WizModernImage-IS.bmp"
WizardSmallImageFile="C:\Program Files (x86)\Inno Setup 5\WizModernSmallImage-IS.bmp"
AppMutex=blc_app_emu
LicenseFile=docs\License.txt

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked
Name: "quicklaunchicon"; Description: "{cm:CreateQuickLaunchIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked; OnlyBelowVersion: 0,6.1

[Files]
Source: {#MyAppMainExe}; DestDir: "{app}"; Flags: ignoreversion
; NOTE: Don't use "Flags: ignoreversion" on any shared system files
Source: win32\build_scripts\emu.ini; DestDir: {app}; Flags: onlyifdoesntexist IgnoreVersion; Permissions: users-modify;
Source: D:\projects\fonts\current\combined\FICEAL0L80x25.fon; DestDir: {app}\fonts; Flags: IgnoreVersion;
Source: D:\projects\fonts\current\combined\FICEAL0M80x25.fon; DestDir: {app}\fonts; Flags: IgnoreVersion;
Source: D:\projects\fonts\current\combined\FICEAL1L80x25.fon; DestDir: {app}\fonts; Flags: IgnoreVersion;
Source: D:\projects\fonts\current\combined\FICEAL1M80x25.fon; DestDir: {app}\fonts; Flags: IgnoreVersion;
Source: D:\projects\fonts\current\combined\FICEAL2L80x25.fon; DestDir: {app}\fonts; Flags: IgnoreVersion;
Source: D:\projects\fonts\current\combined\FICEAL2M80x25.fon; DestDir: {app}\fonts; Flags: IgnoreVersion;
Source: D:\projects\fonts\current\combined\FICEENG1L80x25.fon; DestDir: {app}\fonts; Flags: IgnoreVersion;
Source: D:\projects\fonts\current\combined\FICEENG1M80x25.fon; DestDir: {app}\fonts; Flags: IgnoreVersion;
Source: D:\projects\fonts\current\combined\FICEENG2L80x25.fon; DestDir: {app}\fonts; Flags: IgnoreVersion;
Source: D:\projects\fonts\current\combined\FICEENG2M80x25.fon; DestDir: {app}\fonts; Flags: IgnoreVersion;

[Icons]
Name: "{group}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"
Name: "{commondesktop}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"; Tasks: desktopicon
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"; Tasks: quicklaunchicon



