//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#ifndef WinScreenInterfaceH
#define WinScreenInterfaceH
//---------------------------------------------------------------------------
// File: WinScreenInterface.h
// Desc.: Header file for the Windows based implementation of the
//    ScreenInterface class.
// Notes: The classes specified in this header file are specific to Win32
//---------------------------------------------------------------------------
// TODO:
//    -
//---------------------------------------------------------------------------
// Version History:
//    19/08/2001, 0.0.0
//       - Created the file with the outline of each class
//    08/01/2002, 0.0.1
//       - Temporary fix for character comparison problem
//    15/02/2002, 0.0.2
//       - Fixed problem with Normal character set selection when
//       character was less that Hex(90) and had the alternate font flag set
//    16/02/2002, 0.0.3, Mark Pickersgill
//       - Changed variable and method names to conform to the coding standard
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Required CUSTOM header files
//---------------------------------------------------------------------------
#include "ScreenInterface.h"
#include "TScreenControl.h"
//---------------------------------------------------------------------------
// Required SYSTEM header files
//---------------------------------------------------------------------------
#include <Graphics.hpp>
//---------------------------------------------------------------------------
// Macros and constants
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// --== DECLARATIONS ==--
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Supporting Functions
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Class: WinScreenInterface
// Desc.: Windows Specific Screen Interface Class
//---------------------------------------------------------------------------
class WinScreenInterface : public ScreenInterface
{
private :
   TComponent *_owner;
   TScreenControl *_screen;
   int _fontSize;    // This needs to be stored here as it's dependant on the win32 platform
   int _forcedFontSize; // ### This is used to force a font size. 0 for low res, 1 for medium res
   void redrawRect(const TRect &rect, bool toscreen);
   void redrawScreen(const bool toscreen);
   void initVariables(TComponent* Owner);
   bool _boxFlag;
   int _boxX1;
   int _boxY1;
   int _boxX2;
   int _boxY2;
public :
   WinScreenInterface(TComponent* Owner);
   WinScreenInterface(TComponent* Owner, const int width, const int height);
   WinScreenInterface(TComponent* Owner, const int width, const int height,
      const colour_t fore, const colour_t back);
   ~WinScreenInterface();
   colour_t fromWinColour(Graphics::TColor win_colour);
   Graphics::TColor toWinColour(colour_t screen_colour);
   virtual void setCaretOn(const bool state);
   virtual bool getCaretOn(void) const;
   virtual bool clearScreen(void);
   virtual bool moveCaret(const direction_t direction, const int count=1);
   virtual void setColour(c_control_t c_control, colour_t colour);
   virtual void setDefColour(c_control_t c_control, colour_t colour);
   virtual void defColoursToCur();
//   virtual void SetCurAttribs(const TMCharAttribs &attribute);
//   virtual void GetCurAttribs(TMCharAttribs &attribute);
   virtual void setStoredAttribs(const attrib_t &attribute);
   virtual void getStoredAttribs(attrib_t &attribute) const;
   virtual void toggleAttribs(bool on);
   virtual void putChar(char character);
   virtual void scrollDown(int lines=1);
   virtual void setCharSet(charSet_t char_set);
   virtual charSet_t getCharSet(void);
   virtual void setRealUnderline(bool on);
   virtual void setRealReverse(bool on);
   virtual void setRealBright(bool on);
   virtual void setRealBlink(bool on);
   virtual void setDrawBoxLines(bool on);
   virtual bool getRealUnderline(void);
   virtual bool getRealReverse(void);
   virtual bool getRealBright(void);
   virtual bool getRealBlink(void);
   virtual void clearStatusLine(void);
   virtual void setStatusLineAttribs(attrib_t attribs);
   virtual bool writeStatusLine(char character, bool scroll);
   virtual void finishStatusLine(void);
   virtual void calcFontNames(language_t language, int resX, int resY, int screenX,
      int screenY);
   virtual void beep(void);
   virtual void setWidth(const int width);
   virtual void setHeight(const int height);
   virtual int setup(void);
   virtual bool loadSetup(const string &fileName);
   virtual bool saveSetup(const string &fileName);
   virtual void redraw();
   virtual void beginDrawBox();
   virtual void endDrawBox();
   virtual int getPixelWidth();
   virtual int getPixelHeight();
   virtual void drawTextLine(const direction_t direction, bool erase);
   ScreenInterface::initScreen;
};

#endif
//---------------------------------------------------------------------------
// END OF FILE
//---------------------------------------------------------------------------