//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#ifndef WinPrinterInterfaceH
#define WinPrinterInterfaceH
//---------------------------------------------------------------------------
// File: WinPrinterInterface.h
// Desc.: Header file for the Win32 specific class implementation of the
//    WinPrinterInterface class.
//
//---------------------------------------------------------------------------
//  Created: 06/01/2002
//  Version History:
//    06/01/2002, 0.0.0 - Basic class outline
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Required CUSTOM header files
//---------------------------------------------------------------------------
#include "PrinterInterface.h"
#include "TextPrint.h"  // Text printer component
//---------------------------------------------------------------------------
// Required SYSTEM header files
//---------------------------------------------------------------------------
#include <fstream.h>
#include <string>
#include <classes.hpp>
//---------------------------------------------------------------------------
// --== Macros and constants ==--
//---------------------------------------------------------------------------
#define PRINTER_SECTION "Printer Settings"

//---------------------------------------------------------------------------
// --== DECLARATIONS ==--
//---------------------------------------------------------------------------
// Printer output devices
enum outDev_t {
   OUT_DEV_PRINTER=0,
   OUT_DEV_FILE
   };

//---------------------------------------------------------------------------
// Class: WinPrinterInterface
// Desc.: Win32 specific Printer Interface Class
//---------------------------------------------------------------------------
class WinPrinterInterface : public PrinterInterface
{
private :
   TComponent *_owner;
   string *_fileName;
   string *_dataType;
   fstream *_currentFile;
   outDev_t _outDevice;
   outDev_t _defOutDevice; // Default output device
   outDev_t _prevOutDevice;
   string *_newPageId;
   string *_printerName;
   string *_defFileName;   // Default filename
   unsigned int _timeout;
   unsigned int _timeCount;
   bool _ignorePrintCodes;
   bool _useTransTable;
   unsigned char _dataSeparator;
   TTextPrint *_textPrinter;
public :
   WinPrinterInterface(TComponent *Owner);
   ~WinPrinterInterface();
   // Adds a character to the internal filename to be printed to
   virtual void addToFileName(char letter);
   // Sets the internal filename to the input filename
   virtual void setFileName(const string &newFileName);
   virtual void print(const char letter);
   // Switches from printing to the file back to the printer
   virtual void switchToPrinter();
   virtual void switchToFile();
   // Closes the file opened previously and clears the filename
   virtual void close();
   virtual bool checkTimeout(long int increment = 5); // increment is in seconds
//   virtual void setTimeout(unsigned int timeout) { if (_timeCount == _timeout) _timeCount = timeout; _timeout = timeout;  };
//   virtual unsigned int getTimeout() { return _timeout; };
   virtual int setup();
   virtual bool loadSetup(const string &fileName);
   virtual bool saveSetup(const string &fileName);
};
#endif
//---------------------------------------------------------------------------
// END OF FILE
//---------------------------------------------------------------------------
