//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#ifndef WinMainSetupInterfaceH
#define WinMainSetupInterfaceH
//---------------------------------------------------------------------------
// File: WinMainSetupInterface.h
// Desc.: Base class for the Setup class
//
//---------------------------------------------------------------------------
// Created: 03/01/2002
// Version History:
//    03/01/2002, 0.0.0 - First Implementation
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Required CUSTOM header files
//---------------------------------------------------------------------------
#include "SetupInterface.h"
//---------------------------------------------------------------------------
// Required SYSTEM header files
//---------------------------------------------------------------------------
#include <stdlib.h>
#include <fstream.h>
#include <string.h>
#include <string>
#include <SysUtils.hpp>
#include <Classes.hpp>
//---------------------------------------------------------------------------
// --== Macros and constants ==--
//---------------------------------------------------------------------------
#define GENERAL_SECTION "General Settings"
//---------------------------------------------------------------------------
// --== DECLARATIONS ==--
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// --== Supporting Functions ==--
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Class: SetupInterface
// Desc.: Base class for storing setup options
//---------------------------------------------------------------------------
class WinMainSetupInterface : public MainSetupInterface
{
private:
   TComponent *_owner;
public:
   // Display the Setup Screen
   WinMainSetupInterface(TComponent *Owner);
   ~WinMainSetupInterface();
   virtual int setup(void);
   virtual bool loadSetup(const string &fileName);
   virtual bool saveSetup(const string &fileName);
   AnsiString _dialnum;
};
#endif

//---------------------------------------------------------------------------
// END OF FILE
//---------------------------------------------------------------------------