//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// File: WinMainSetupInterface.cpp
// Desc.: Implementation file for the Main Setup storage class for the Emu
//    program.
//
//---------------------------------------------------------------------------
// Created: 03/01/2002
// Version History:
//    03/01/2002, 0.0.0 - First skeleton Implementation
//
// SEE HEADER FILE FOR FULL VERSION HISTORY
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Required CUSTOM header files
//---------------------------------------------------------------------------
#include "WinMainSetupInterface.h"
#include "TMainSetupForm.h"
//---------------------------------------------------------------------------
// Required SYSTEM header files
//---------------------------------------------------------------------------
#include <inifiles.hpp>
#include <memory>
//---------------------------------------------------------------------------
// --== IMPLEMENTATION ==--
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Supporting Functions
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Class:
// Desc.:
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// PRIVATE Methods
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// PUBLIC Methods
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
WinMainSetupInterface::WinMainSetupInterface(TComponent *Owner) : MainSetupInterface()
{
_owner = Owner;
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
WinMainSetupInterface::~WinMainSetupInterface()
{
_owner = NULL;
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
int WinMainSetupInterface::setup(void)
{
// Display the setup screen and obtain the setup values
if (_owner != NULL)
   {
   // Display setup screen for the ComPort
   TMainSetupForm *setupForm = new TMainSetupForm(_owner);
   // Setup the screen display with the current values
   setupForm->openOnStart->Checked = _openOnStart;
   setupForm->confirmExit->Checked = _confirmExit;
   setupForm->capsOnStart->Checked = _capsOnStart;
   setupForm->toggleCaps->Checked = _capsOnFocus;
   setupForm->keyTableName->Text = _keyMapFile.data();
   setupForm->loggingOn->Checked = _loggingOn;
   setupForm->rgWangFlowCtrl->ItemIndex = _wangFlowCtrl;
   int result = setupForm->ShowModal();
   if (result == mrOk)
      {
      // Extract the setup from the Form
      _openOnStart = setupForm->openOnStart->Checked;
      _confirmExit = setupForm->confirmExit->Checked;
      _capsOnStart = setupForm->capsOnStart->Checked;
      _capsOnFocus = false; //setupForm->toggleCaps->Checked;
	  _keyMapFile = setupForm->keyTableName->Text.c_str();
      _loggingOn = setupForm->loggingOn->Checked;
      _wangFlowCtrl = WangFlowCtrl_t(setupForm->rgWangFlowCtrl->ItemIndex);
      }
   delete setupForm;
   return (result);
   }
else
   return (mrCancel);
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
bool WinMainSetupInterface::loadSetup(const string &fileName)
{
try
   {
   auto_ptr<TIniFile> setupFile (new TIniFile(fileName.data()));
   _openOnStart = setupFile->ReadBool(GENERAL_SECTION, "Open on Start", true);
   _confirmExit = setupFile->ReadBool(GENERAL_SECTION, "Confirm Exit", true);
   _capsOnStart = setupFile->ReadBool(GENERAL_SECTION, "Caps on Start", false);
   _capsOnFocus = setupFile->ReadBool(GENERAL_SECTION, "Caps on Focus", false);
   _keyMapFile = setupFile->ReadString(GENERAL_SECTION, "Keyboard Table", "").c_str();
   _loggingOn = setupFile->ReadBool(GENERAL_SECTION, "Logging On", false);
   _wangFlowCtrl = WangFlowCtrl_t(setupFile->ReadInteger(GENERAL_SECTION, "Wang Flow Control", 0));
   //### Bit of a hack for auto-dial
   if (setupFile->ReadBool("Auto-Dial", "DialOnStartup", false))
      _dialnum = setupFile->ReadString("Auto-Dial", "PhoneNumber", "");
   else
      _dialnum = "";
   return (true);
   }
catch (...)
   {
   return (false);
   }
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
bool WinMainSetupInterface::saveSetup(const string &fileName)
{
// Save the setup options to an ini file
try
   {
   auto_ptr<TIniFile> setupFile (new TIniFile(fileName.data()));
   setupFile->WriteBool(GENERAL_SECTION, "Open on Start", _openOnStart);
   setupFile->WriteBool(GENERAL_SECTION, "Confirm Exit", _confirmExit);
   setupFile->WriteBool(GENERAL_SECTION, "Caps on Start", _capsOnStart);
   setupFile->WriteBool(GENERAL_SECTION, "Caps on Focus", _capsOnFocus);
   setupFile->WriteString(GENERAL_SECTION, "Keyboard Table", _keyMapFile.data());
   setupFile->WriteBool(GENERAL_SECTION, "Logging On", _loggingOn);
   setupFile->WriteInteger(GENERAL_SECTION, "Wang Flow Control", _wangFlowCtrl);
   return (true);
   }
catch (...)
   {
   return (false);
   }
}

//---------------------------------------------------------------------------
// END OF FILE
//---------------------------------------------------------------------------