//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// File: WinKeyMap.cpp
// Desc.: Implementation file for the Windows based KeyMap class
//
// NOTE: The classes implemented in this file are specific to Win32
//---------------------------------------------------------------------------
// Created: 24/08/2001
// Version History:
//    24/08/2001, 0.0.0 - First skeleton Implementation
//
// SEE HEADER FILE FOR FULL VERSION HISTORY
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Required CUSTOM header files
//---------------------------------------------------------------------------
#include "WinKeyMap.h"
#include "TKeyMapSetupForm.h"
#include <memory>
//---------------------------------------------------------------------------
// Required SYSTEM header files
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// --== IMPLEMENTATION ==--
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Supporting Functions
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Class: WinKeyMap
// Desc.: WinKeyMap provides the extra methods required for the KeyMap class
//    under a Win32 environment
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// PRIVATE Methods
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// PUBLIC Methods
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
WinKeyMap::WinKeyMap(TComponent *Owner)
   : KeyMap()
{
_owner = Owner;
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
WinKeyMap::~WinKeyMap()
{
_owner = NULL;
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
void WinKeyMap::setup(void)
{
if (_owner != NULL)
   {
   auto_ptr<TKeyMapSetupForm> setupScreen (new TKeyMapSetupForm(_owner, this));
   setupScreen->ShowModal();
   }
}

//---------------------------------------------------------------------------
// END OF FILE
//---------------------------------------------------------------------------