//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#ifndef WinFileInterfaceH
#define WinFileInterfaceH
//---------------------------------------------------------------------------
// File: WinFileInterface.h
// Desc.: Header file for the Windows based implementation of the 
//    FileInterface class.
//
// NOTE: The classes specified in this header file are specific to Win32
//---------------------------------------------------------------------------
// Created: 17/08/2001
// Version History:
//    17/08/2001, 0.0.0 - Created the file with the outline of each class
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Required CUSTOM header files
//---------------------------------------------------------------------------
#include "fileinterface.h"
//---------------------------------------------------------------------------
// Required SYSTEM header files
//---------------------------------------------------------------------------
#include <fstream.h>
#include <string>

//---------------------------------------------------------------------------
// --== DECLARATIONS ==--
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Class: WinFileInterface
// Desc.: Windows Specific File Interface Class
//---------------------------------------------------------------------------
class WinFileInterface : public FileInterface 
{
private :
   string *_fileName;
   fstream *_currentFile;
public :
   WinFileInterface();
   // Destructor
   ~WinFileInterface();
   void addToFileName(const char letter);
   void setFileName(const string &fileName);
   char create(void);
   char exists(void);
   char open(void);
   void write(const char *dataBuffer, int size);
   void put(const char character);
   void flush(void);
   void close(void);
};

#endif
//---------------------------------------------------------------------------
// END OF FILE
//---------------------------------------------------------------------------