//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#ifndef WinCommInterfaceH
#define WinCommInterfaceH
//---------------------------------------------------------------------------
// File: WinCommInterface.h
// Desc.: Header file for the Win32 secific Communications port object
//
//---------------------------------------------------------------------------
// Created: 17/09/2001
// Version History:
//    17/09/2001, 0.0.0 - First Implementation
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Required CUSTOM header files
//---------------------------------------------------------------------------
#include "CommInterface.h"
#include "CPort.hpp"
//#include "CPortCtl.hpp"
//---------------------------------------------------------------------------
// Required SYSTEM header files
//---------------------------------------------------------------------------
#include <fstream.h>
#include <string.h>
#include <string>
//---------------------------------------------------------------------------
// --== Macros and constants ==--
//---------------------------------------------------------------------------
#define COM_SECTION "Com Port"
//---------------------------------------------------------------------------
// --== DECLARATIONS ==--
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// --== Supporting Functions ==--
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Class: WinCommInterface
// Desc.: Win32 Specific Communications port class
//---------------------------------------------------------------------------
class WinCommInterface : public CommInterface
{
private:
   TComponent *_owner;
   TComPort *_comPort;
   void __fastcall _onReceive(TObject *Sender, int Count);
   void __fastcall _onOpen(TObject *Sender);
   void __fastcall _onClose(TObject *Sender);
   void __fastcall _on80Full(TObject *Sender);
public:
   WinCommInterface(TComponent *Owner);
   ~WinCommInterface();
   virtual bool isOpen(void);
   // Opens the Comm port
   virtual void open(void);
   // Closes the Comm port
   virtual void close(void);
   // Display the Setup Screen
   virtual int setup(void);
   void setDefaultFlowCtrl(void);
   virtual void setDefaults(void);
   virtual bool loadSetup(const string &fileName);
   virtual bool saveSetup(const string &fileName);
   virtual int read(char *buffer, const int count);
   virtual int write(char *buffer, const int count);
   virtual void getSetupString(char *buffer);
};

#endif

//---------------------------------------------------------------------------
// END OF FILE
//---------------------------------------------------------------------------