//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#ifndef VersionH
#define VersionH
//---------------------------------------------------------------------------
// File: Version.h
// Desc.: Contains Version History for the Win32 implementation of EMU
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// --== Macros and Constants ==--
//---------------------------------------------------------------------------
#define VERSION_STR "1.12"
//---------------------------------------------------------------------------
// TODO:
//    -
//---------------------------------------------------------------------------
/**
Authors:
   MP = Mark Pickersgill

Version History:
1.12     13-03-05    -MP Uses common FiceFont unit for determining the font names
                     -MP Uses common font loader component
1.11     04-01-05    -MP Added Box line drawing capability
                     -MP Added Box line colour and on/off options
                     -MP Implemented screen initialization sequence
1.10     12-12-04    -MP Changed minimum printer timeout to 4 seconds instead of 10
                     -MP Fixed attribute scrolling issue. Attributes were not being scrolled
                         correctly.
                     -MP Changed format of the version history file
1.09     15-05-04    -MP Fixed Title bar status update when comport settings are changed
                     -MP Fixed saving of comport flow control setting.
                     -MP Updated all fonts, so there is now a full set of 80x25 fonts in low
                         and medium resolution.
                     -MP Auto-dial correctly disables then enables the WANG flow control after
                         it has connected
                     -MP Debug filename option removed from General settings screen. Debug
                         output file is now EMU.LOG
                     -MP Setting of Comport defaults has been placed into one method.
                     -MP Comport settings are reverted back if the Cancel button is pressed in
                         the Comport Setup screen.
                     -MP Fixed focus problem on startup (this was caused by the KeyState
                         component loading its defaults on creation.
                     -MP Caps on Startup option re-introduced.
                     -MP Title bar is now updated before comport is opened to ensure the
                         title bar is correct, even if the comport couldn't be opened.
1.08     11-01-04    -MP Added a Printer data type option so some printers could print in TEXT
                         mode rather than RAW mode, which prevented some printers from
                         printing at all.
1.07     20-11-03    -MP Allowed phone number field in auto-dial to include modem AT commands
1.06     18-11-03    -MP Added crude auto-dialing
1.05     08-11-03    -MP New version numbering
                     -MP Fixed EMU hanging on Windows 98 machines when listing printers
1.04     31-10-03    -MP Recompiled with updated TextPrinter component to fix printer listing
                         problem.
1.03     08-09-03    -MP Defaulted "bright, blink" colour to Light Cyan (was previously black)
                     -MP Added "bright, blink" colour selection to screen setup dialog
                     -MP Enabled F2 and F10 keys to work in ASCII Transfer dialog
1.2.2    31-08-03    -MP Minor tweaks to the Printer setup form
1.2.1    25-08-03    -MP Added Release Printer option to printer menu
                     -MP Added Send New Page option to printer menu
1.2.0    03-08-03    -MP Removed auto CAPS lock functionality
                     -MP Modified Printer handling to keep printer open until no data has been
                         sent to the printer for a certain period of time. Then the printer is
                         closed.
                     -MP Allowed Printer's current settings to be modified in setup screen
                     -MP Added SHIFT+SPACE to basic keyboard table loading
                     -MP Centered the screen when font size is changed
                     -MP Caret now adjusts to the correct screen position on font change
                     -MP Fixed erroneous loading of strings from a keymap file
                     -MP Fixed comm port flow control so EMU will receive data when Fasstcom
                         is first loaded.
1.1.1    24-07-03    -MP Added a redraw facility into the screen to allow colours to take effect immediately
                     -MP Added the setting of the fore, back and blink screen colours
                     -MP Added ability to force the font size used
                     -MP Medium font size introduced
                     -MP Fixed Print-to-file function not flushing data to disk often enough
1.1.01   02-07-03    -MP Changed Font handling so that fonts are divided up into 0-7F for language sets
                         and 80-FF for alternate sets.
                     -MP Added alternate character set 2 fonts.
                     -MP Correctly initialized attributes for new characters when scrolling
                     -MP Fixed picking of screen colours based on the attribute.
                     -MP Defaulted WANG Flow control to Force
                     -MP Fixed Caps lock control for focus and unfocus
                     -MP Corrected upper case being output when CAPS + SHIFT was pressed with an alpha key
                     -MP Added ability to not number lines when doing an ASCII file transfer
1.0.0    29-06-03    -MP Initial Beta Release
                     -MP Tidied up the ASCII file transfer code
0.0.8    25-06-03    -MP Fixed the incorrect cursor positioning when backspacing to the previous line
                     -MP Added in an ASCII File Transfer screen
0.0.7    23-06-03    -MP Fixed print to file not working when specified in options screen
                     -MP Fixed FB interrupt sequence when switching from screen to printer
                     -MP Changed debugging to always append to the file
0.0.6    09-06-03    -MP Added this Version.h file
                     -MP Fixed the KeyMap implementation
                     -MP Swapped the names of the hexBufToStr & strToHexBuf functions
                     -MP Added the Baud rate to the caption bar
0.0.5    19-09-02    -MP First Alpha release

*/
//---------------------------------------------------------------------------

#endif

//---------------------------------------------------------------------------
// END OF FILE
//---------------------------------------------------------------------------
