//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#ifndef TScreenControlH
#define TScreenControlH
//---------------------------------------------------------------------------
// File: TScreenControl.h
// Desc.: Header file for the text screen WinControl
// Notes: The classes specified in this header file are specific to Win32
//---------------------------------------------------------------------------
// TODO:
//    -
//---------------------------------------------------------------------------
// Version History:
//    19/08/2001, 0.0.0, Mark Pickersgill
//       - Created the file and implemented basic functions of drawing to the
//       screen
//    08/01/2002, 0.0.1, Mark Pickersgill
//       - Fixed a few bugs
//    16/02/2002, 0.0.2, Mark Pickersgill
//       - Changed variable and method names to conform to the coding standard
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Required CUSTOM header files
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Required SYSTEM header files
//---------------------------------------------------------------------------
#include <SysUtils.hpp>
#include <Controls.hpp>
#include <Classes.hpp>
#include <Forms.hpp>
//---------------------------------------------------------------------------
// Macros and constants
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// --== DECLARATIONS ==--
//---------------------------------------------------------------------------
enum scrollDir_t {SD_UP, SD_DOWN, SD_LEFT, SD_RIGHT};
//---------------------------------------------------------------------------
// Supporting Functions
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Class: TScreenControl
// Desc.: Windows Specific Screen WinControl Class
//---------------------------------------------------------------------------
class PACKAGE TScreenControl : public TCustomControl
{
private:
   Graphics::TBitmap *_finalBitmap;
   Graphics::TBitmap *_txtBitmap;
   Graphics::TBitmap *_graphicsBitmap;
   Graphics::TBitmap *_bwBitmap;
   TRect _scrollRect;
   int _lastCaretPosX;
   int _lastCaretPosY;
   bool _caretCreated;
   bool _caretOn;
   bool _resizeWithBitmap; // Set this to true if the control should be resized with the bitmap
   bool _ignoreGraphics;   // Ignores copying the graphics bitmap to the screen - allows faster drawing (but no boxes,lines etc)
   int _fontWidth;
   int _fontHeight;
   MESSAGE void __fastcall WMGetDlgCode(TWMGetDlgCode &Message);
   MESSAGE void __fastcall WMKillFocus(TWMKillFocus &Message);
   MESSAGE void __fastcall WMSetFocus(TWMSetFocus &Message);
protected:
   void __fastcall Paint(void);
   void __fastcall setColumns(const int columns);
   void __fastcall setLines(const int lines);
//   void __fastcall setFontWidth(const int fontWidth);
//   void __fastcall setFontHeight(const int fontHeight);
   int __fastcall getFontWidth(void);
   int __fastcall getFontHeight(void);
   void __fastcall setResizeWithBitmap(bool state);
   bool __fastcall getResizeWithBitmap(void);
   void __fastcall setIgnoreGraphics(const bool on);
public:
   BEGIN_MESSAGE_MAP
      MESSAGE_HANDLER(WM_GETDLGCODE, TWMGetDlgCode, WMGetDlgCode);
      MESSAGE_HANDLER(WM_KILLFOCUS, TWMKillFocus, WMKillFocus);
      MESSAGE_HANDLER(WM_SETFOCUS, TWMSetFocus, WMSetFocus);
   END_MESSAGE_MAP(TCustomControl);
   __fastcall TScreenControl(TComponent* Owner);
   __fastcall ~TScreenControl();
   // Gets the font height and width and adjusts the screen size using the font
   // height and width and the number of text columns and lines
   void __fastcall adjustForFont(AnsiString fontName, int fontSize);
   void __fastcall paintRect(const TRect &rect, const bool ignoreGraphics, const bool toscreen);
   void __fastcall copyRect(const TRect &rect);
   void __fastcall paintAll(void);
   void __fastcall noScrollRegion(const int colsLeft, const int linesTop, const int colsRight, const int linesBottom);
   void __fastcall scroll(scrollDir_t direction, int count);
   // Caret control
   void __fastcall winCaretOn(const bool state);
   void __fastcall winSetCaretPos(const int xpos, const int ypos);
   void __fastcall winShowCaret();
   void __fastcall winHideCaret();
   void __fastcall drawLine(const int x1, const int y1, const int x2, const int y2, bool erase, TColor colour);
   void __fastcall clearGraphics(bool redraw=true);
   void __fastcall clearGraphicsRect(const TRect &rect, bool redraw=true);
   __property Graphics::TBitmap *TextBitmap={read=_txtBitmap};
   __property Graphics::TBitmap *FinalBitmap={read=_finalBitmap};
__published:
   __property Align;
   __property TabStop;
   __property OnKeyDown;
   __property OnKeyPress;
   __property int ScreenColumns={write=setColumns};
   __property int ScreenLines={write=setLines};
   __property int FontHeight={read=getFontHeight};
   __property int FontWidth={read=getFontWidth};
   __property bool ResizeWithBitmap={read=getResizeWithBitmap, write=setResizeWithBitmap};
   __property bool IgnoreGraphics={read=_ignoreGraphics, write=setIgnoreGraphics};
};
//---------------------------------------------------------------------------
#endif
