//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TScreenControl.h"
#pragma link "TScreenControl.obj"
#pragma package(smart_init)

//---------------------------------------------------------------------------
// Method: ()
// Desc.: ValidCtrCheck is used to assure that the components created do not
//    have any pure virtual functions.
// Return:
// Notes:
//---------------------------------------------------------------------------
static inline void ValidCtrCheck(TScreenControl *)
{
   new TScreenControl(NULL);
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
__fastcall TScreenControl::TScreenControl(TComponent* Owner)
   : TCustomControl(Owner)
{
_finalBitmap = new Graphics::TBitmap();
_txtBitmap = new Graphics::TBitmap();
_graphicsBitmap = new Graphics::TBitmap();
_bwBitmap = new Graphics::TBitmap();
// Set the common colouring for the graphics bitmaps
SetTextColor(_finalBitmap->Canvas->Handle, 0);
SetBkColor(_finalBitmap->Canvas->Handle, 0xFFFFFF);
_bwBitmap->Monochrome = true;
_bwBitmap->Canvas->Brush->Style = bsSolid;
_bwBitmap->Canvas->Brush->Color = clBlack;
_bwBitmap->Canvas->Pen->Color = clWhite;
_graphicsBitmap->Canvas->Brush->Style = bsSolid;
_graphicsBitmap->Canvas->Brush->Color = clWhite;
_graphicsBitmap->Canvas->Pen->Color = clRed;

// ### Check that the font size does not have to be changed for each resolution
// The following size assignments are simply to get some workable values
//TextBitmap->Canvas->Font->Size = 13;
_txtBitmap->Canvas->Font->Pitch = fpFixed;
_fontHeight = _txtBitmap->Canvas->TextHeight("W");
_fontWidth = _txtBitmap->Canvas->TextWidth("W");
_finalBitmap->Width = Width;
_finalBitmap->Height = Height;
_txtBitmap->Width = Width;
_txtBitmap->Height = Height;
_graphicsBitmap->Width = Width;
_graphicsBitmap->Height = Height;
_bwBitmap->Width = Width;
_bwBitmap->Height = Height;
clearGraphics(false);
_scrollRect = Rect(0, 0, _finalBitmap->Width, _finalBitmap->Height);
// Initialise the caret variables
_caretOn = true;
_lastCaretPosX = 0;
_lastCaretPosY = _fontHeight-2;
TabStop = true;
_resizeWithBitmap = false;
// ###Testing section

//_caretCreated = false;
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
__fastcall TScreenControl::~TScreenControl()
{
// The Kill Focus message will be sent after this message is processed
delete _bwBitmap;
delete _graphicsBitmap;
delete _txtBitmap;
delete _finalBitmap;
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
void __fastcall TScreenControl::WMGetDlgCode(TWMGetDlgCode &Message)
{
Message.Result = DLGC_WANTARROWS|DLGC_WANTCHARS|DLGC_WANTTAB;
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
void __fastcall TScreenControl::WMKillFocus(TWMKillFocus &Message)
{
DestroyCaret();
_caretCreated = false;
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
void __fastcall TScreenControl::WMSetFocus(TWMSetFocus &Message)
{
CreateCaret(Handle, NULL, _fontWidth, 2);
_caretCreated = true;
if (_caretOn)
   {
   SetCaretPos(_lastCaretPosX, _lastCaretPosY);
   winCaretOn(true);
   }
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
void __fastcall TScreenControl::Paint(void)
{
TRect rect;

rect.Left = Canvas->ClipRect.Left;
rect.Right = Canvas->ClipRect.Right;
rect.Top = Canvas->ClipRect.Top;
rect.Bottom = Canvas->ClipRect.Bottom;
Canvas->CopyRect(rect, _finalBitmap->Canvas, rect);
}

void __fastcall TScreenControl::drawLine(const int x1, const int y1, const int x2, const int y2, bool erase, TColor colour)
{
TColor c = _graphicsBitmap->Canvas->Pen->Color;

if (erase)
   {
   _bwBitmap->Canvas->Pen->Color = clBlack;
   _graphicsBitmap->Canvas->Pen->Color = clWhite;
   }
else
   {
   _graphicsBitmap->Canvas->Pen->Color = colour;
   }

_graphicsBitmap->Canvas->MoveTo(x1, y1);
_bwBitmap->Canvas->MoveTo(x1, y1);
_graphicsBitmap->Canvas->LineTo(x2, y2);
_bwBitmap->Canvas->LineTo(x2, y2);

// Restore the previous pen colours
_graphicsBitmap->Canvas->Pen->Color = c;
_bwBitmap->Canvas->Pen->Color = clWhite;
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
void __fastcall TScreenControl::clearGraphicsRect(const TRect &rect, bool redraw)
{
_bwBitmap->Canvas->FillRect(rect);
_graphicsBitmap->Canvas->FillRect(rect);
if (redraw)
   {
   paintRect(rect, true, true);
   }
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
void __fastcall TScreenControl::clearGraphics(bool redraw)
{
TRect rect = Rect(0, 0, _finalBitmap->Width, _finalBitmap->Height);
clearGraphicsRect(rect, redraw);
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
void __fastcall TScreenControl::paintRect(const TRect &rect, const bool ignoreGraphics, const bool toscreen)
{
// Copy the Text canvas first
_finalBitmap->Canvas->CopyRect(rect, _txtBitmap->Canvas, rect);

if (!_ignoreGraphics && !ignoreGraphics)
   {
   // Draw the box lines and graphics
   COLORREF c1 = SetTextColor(_finalBitmap->Canvas->Handle, 0);
   COLORREF c2 = SetBkColor(_finalBitmap->Canvas->Handle, 0xFFFFFF);
   BitBlt(_finalBitmap->Canvas->Handle, 0, 0, rect.Right, rect.Bottom, _bwBitmap->Canvas->Handle, 0, 0, SRCPAINT);
   BitBlt(_finalBitmap->Canvas->Handle, 0, 0, rect.Right, rect.Bottom, _graphicsBitmap->Canvas->Handle, 0, 0, cmSrcAnd);
   SetTextColor(_finalBitmap->Canvas->Handle, c1);
   SetBkColor(_finalBitmap->Canvas->Handle, c2);
   //MaskBlt(_finalBitmap->Canvas->Handle, 0, 0, rect.Right, rect.Bottom, _graphicsBitmap->Canvas->Handle, 0, 0, _bwBitmap->Handle, 0, 0, MAKEROP4(0x00AA0029, SRCCOPY));
   }

if (toscreen)
   {
   winCaretOn(false);
   Canvas->CopyRect(rect, _finalBitmap->Canvas, rect);
   winCaretOn(true);
   }
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.: Draws the final bitmap to the screen
// Return:
// Notes:
//---------------------------------------------------------------------------
void __fastcall TScreenControl::copyRect(const TRect &rect)
{
winCaretOn(false);
Canvas->CopyRect(rect, _finalBitmap->Canvas, rect);
winCaretOn(true);
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.: Paints the entire final bitmap to the screen
// Return:
// Notes:
//---------------------------------------------------------------------------
void __fastcall TScreenControl::paintAll(void)
{
paintRect(Rect(0, 0, _finalBitmap->Width, _finalBitmap->Height), false, true);
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.: Defines the region of the bitmap to actually scroll based on what &
//    how many lines and columns around the edges are not to be scrolled
// Return:
// Notes:
//---------------------------------------------------------------------------
void __fastcall TScreenControl::noScrollRegion(const int colsLeft,
   const int linesTop, const int colsRight, const int linesBottom)
{
_scrollRect = Rect(0, 0, _finalBitmap->Width, _finalBitmap->Height);
_scrollRect.Top = linesTop * _fontHeight;
_scrollRect.Bottom = _scrollRect.Bottom - (linesBottom * _fontHeight);
_scrollRect.Left = colsLeft * _fontWidth;
_scrollRect.Right = _scrollRect.Right - (colsRight * _fontWidth);
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
void __fastcall TScreenControl::scroll(scrollDir_t direction, int count)
{
TRect destRect = _scrollRect, srcRect = _scrollRect;
TRect diffRect = _scrollRect;
int pixelCount;

switch (direction)
   {
   case SD_UP :
      pixelCount = count * _fontHeight;
      destRect.Top = pixelCount;
      srcRect.Bottom = srcRect.Bottom - pixelCount;
      _txtBitmap->Canvas->CopyRect(destRect, _txtBitmap->Canvas, srcRect);
      _bwBitmap->Canvas->CopyRect(destRect, _bwBitmap->Canvas, srcRect);
      _graphicsBitmap->Canvas->CopyRect(destRect, _graphicsBitmap->Canvas, srcRect);
      // scroll the other bitmaps as well
   break;
   case SD_DOWN :
      pixelCount = count * _fontHeight;
      destRect.Bottom = destRect.Bottom - pixelCount;
      srcRect.Top = pixelCount;
      _txtBitmap->Canvas->CopyRect(destRect, _txtBitmap->Canvas, srcRect);

      // Need to take into account the single line of pixels at the top of the status line
      srcRect.Bottom++;
      destRect.Bottom++;
      _bwBitmap->Canvas->CopyRect(destRect, _bwBitmap->Canvas, srcRect);
      _graphicsBitmap->Canvas->CopyRect(destRect, _graphicsBitmap->Canvas, srcRect);
      diffRect.Top = destRect.Bottom;
      diffRect.Bottom = srcRect.Bottom;
      clearGraphicsRect(diffRect, true);
   break;
   case SD_LEFT :
      pixelCount = count * _fontWidth;
      destRect.Left = pixelCount;
      srcRect.Right = srcRect.Right - pixelCount;
      _txtBitmap->Canvas->CopyRect(destRect, _txtBitmap->Canvas, srcRect);
      _bwBitmap->Canvas->CopyRect(destRect, _bwBitmap->Canvas, srcRect);
      _graphicsBitmap->Canvas->CopyRect(destRect, _graphicsBitmap->Canvas, srcRect);
      // scroll the other bitmaps as well
   break;
   case SD_RIGHT :
      pixelCount = count * _fontWidth;
      destRect.Right = destRect.Right - pixelCount;
      srcRect.Left = pixelCount;
      _txtBitmap->Canvas->CopyRect(destRect, _txtBitmap->Canvas, srcRect);
      _bwBitmap->Canvas->CopyRect(destRect, _bwBitmap->Canvas, srcRect);
      _graphicsBitmap->Canvas->CopyRect(destRect, _graphicsBitmap->Canvas, srcRect);
      // scroll the other bitmaps as well
   break;
   }
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
void __fastcall TScreenControl::winCaretOn(const bool state)
{
if (state == true)
   {
   if (_caretCreated)
      ShowCaret(Handle);
   }
else
   {
   if (_caretCreated)
      HideCaret(Handle);
   }
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
void __fastcall TScreenControl::winSetCaretPos(const int xpos, const int ypos)
{
// Save the caret position, just in case the window is out of focus
_lastCaretPosX = xpos * _fontWidth;
_lastCaretPosY = ypos * _fontHeight+(_fontHeight-2);
SetCaretPos(_lastCaretPosX, _lastCaretPosY);
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
void __fastcall TScreenControl::setColumns(const int columns)
{
_finalBitmap->Width = columns * _fontWidth;
Width = _finalBitmap->Width;
_txtBitmap->Width = Width;
_graphicsBitmap->Width = Width;
_bwBitmap->Width = Width;
if (_resizeWithBitmap)
   ClientWidth = _finalBitmap->Width;
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
void __fastcall TScreenControl::setLines(const int lines)
{
_finalBitmap->Height = lines * _fontHeight;
Height = _finalBitmap->Height;
_txtBitmap->Height = Height;
_graphicsBitmap->Height = Height;
_bwBitmap->Height = Height;
if (_resizeWithBitmap)
   ClientHeight = _finalBitmap->Height;
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
int __fastcall TScreenControl::getFontWidth()
{
return (_fontWidth);
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
int __fastcall TScreenControl::getFontHeight()
{
return (_fontHeight);
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
void __fastcall TScreenControl::adjustForFont(AnsiString fontName, int fontSize)
{
// Get the width and height of the font and adjust the number of pixels on the
// screen to accomodate all of the lines and columns

// Get the number of columns and lines currently on the screen
int lines = (int)(_txtBitmap->Height / _fontHeight);
int columns = (int)(_txtBitmap->Width / _fontWidth);
// Get the number of non-scrolling lines and columns currently set
int nLinesTop = (int)(_scrollRect.Top / _fontHeight);
int nLinesBottom = (int)((_txtBitmap->Height - _scrollRect.Bottom) / _fontHeight);
int nColsLeft = (int)(_scrollRect.Left / _fontWidth);
int nColsRight = (int)((_txtBitmap->Width - _scrollRect.Right) / _fontWidth);

_txtBitmap->Canvas->Font->Name = fontName;
_txtBitmap->Canvas->Font->Size = fontSize;
// Get the font width and height
_fontWidth = _txtBitmap->Canvas->TextWidth("W");
_fontHeight = _txtBitmap->Canvas->TextHeight("W");
// Set the columns and lines so that the screen size is recalculated
setColumns(columns);
setLines(lines); 
// Set the non-scrolling region
noScrollRegion(nColsLeft, nLinesTop, nColsRight, nLinesBottom);
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
void __fastcall TScreenControl::setResizeWithBitmap(bool state)
{
if (_resizeWithBitmap != state)
   {
   _resizeWithBitmap = state;
   // Redraw window
   }
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
void __fastcall TScreenControl::setIgnoreGraphics(const bool on)
{
if (_ignoreGraphics != on)
   {
   _ignoreGraphics = on;
   paintAll();
   }
}

//---------------------------------------------------------------------------
// Method: ()
// Desc.:
// Return:
// Notes:
//---------------------------------------------------------------------------
bool __fastcall TScreenControl::getResizeWithBitmap(void)
{
return (_resizeWithBitmap);
}

//---------------------------------------------------------------------------
namespace Tscreencontrol
{
   void __fastcall PACKAGE Register()
   {
       TComponentClass classes[1] = {__classid(TScreenControl)};
       RegisterComponents("Samples", classes, 0);
   }
}
//---------------------------------------------------------------------------
