//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

#ifndef TKeyMapSetupFormH
#define TKeyMapSetupFormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
#include <ExtCtrls.hpp>
#include "NewButton.hpp"
#include "KeyMap.h"
#include <Dialogs.hpp>
//---------------------------------------------------------------------------
class TKeyMapSetupForm : public TForm
{
__published:	// IDE-managed Components
   TPanel *KeyBoard;
   TNewButton *BtnInvQuote;
   TNewButton *Btn1;
   TNewButton *Btn2;
   TNewButton *Btn3;
   TNewButton *Btn4;
   TNewButton *Btn5;
   TNewButton *Btn6;
   TNewButton *Btn7;
   TNewButton *Btn8;
   TNewButton *Btn9;
   TNewButton *Btn0;
   TNewButton *BtnMinus;
   TNewButton *BtnEquals;
   TNewButton *BtnBackSlash;
   TNewButton *BtnBack;
   TNewButton *BtnEsc;
   TNewButton *BtnF1;
   TNewButton *BtnF2;
   TNewButton *BtnF3;
   TNewButton *BtnF4;
   TNewButton *BtnF5;
   TNewButton *BtnF6;
   TNewButton *BtnF7;
   TNewButton *BtnF8;
   TNewButton *BtnF9;
   TNewButton *BtnF10;
   TNewButton *BtnF11;
   TNewButton *BtnF12;
   TNewButton *BtnTab;
   TNewButton *BtnQ;
   TNewButton *BtnW;
   TNewButton *BtnE;
   TNewButton *BtnR;
   TNewButton *BtnT;
   TNewButton *BtnY;
   TNewButton *BtnU;
   TNewButton *BtnI;
   TNewButton *BtnO;
   TNewButton *BtnP;
   TNewButton *BtnSquareLeft;
   TNewButton *BtnSquareRight;
   TNewButton *BtnCaps;
   TNewButton *BtnA;
   TNewButton *BtnS;
   TNewButton *BtnD;
   TNewButton *BtnF;
   TNewButton *BtnG;
   TNewButton *BtnH;
   TNewButton *BtnJ;
   TNewButton *BtnK;
   TNewButton *BtnL;
   TNewButton *BtnSemiColon;
   TNewButton *BtnSingleQuote;
   TNewButton *BtnReturn;
   TNewButton *BtnLeftShift;
   TNewButton *BtnZ;
   TNewButton *BtnX;
   TNewButton *BtnC;
   TNewButton *BtnV;
   TNewButton *BtnB;
   TNewButton *BtnN;
   TNewButton *BtnM;
   TNewButton *BtnComma;
   TNewButton *BtnFullStop;
   TNewButton *BtnForwardSlash;
   TNewButton *BtnSpace;
   TNewButton *BtnRightShift;
   TNewButton *BtnLeftCtrl;
   TNewButton *BtnLeftAlt;
   TNewButton *BtnRightAlt;
   TNewButton *BtnRightCtrl;
   TNewButton *BtnInsert;
   TNewButton *BtnDelete;
   TNewButton *BtnHome;
   TNewButton *BtnPrior;
   TNewButton *BtnEnd;
   TNewButton *BtnNext;
   TNewButton *BtnUp;
   TNewButton *BtnLeft;
   TNewButton *BtnDown;
   TNewButton *BtnRight;
   TNewButton *BtnNumLock;
   TNewButton *BtnNumpad7;
   TNewButton *BtnDivide;
   TNewButton *BtnMultiply;
   TNewButton *BtnNumpad8;
   TNewButton *BtnNumpad9;
   TNewButton *BtnSubtract;
   TNewButton *BtnAdd;
   TNewButton *BtnNumpad4;
   TNewButton *BtnNumpad5;
   TNewButton *BtnNumpad6;
   TNewButton *BtnEnter;
   TNewButton *BtnNumpad1;
   TNewButton *BtnNumpad2;
   TNewButton *BtnNumpad3;
   TNewButton *BtnDecimal;
   TLabel *Label1;
   TBevel *Bevel1;
   TGroupBox *AssignDetails;
   TNewButton *BtnNumpad0;
   TRadioButton *LiteralCheck;
   TRadioButton *PreDefinedCheck;
   TEdit *LiteralString;
   TEdit *HexString;
   TComboBox *PreDefinedList;
   TRadioButton *HexCheck;
   TCheckBox *AddEnter;
   TGroupBox *KeyDetails;
   TLabel *Label2;
   TLabel *Label3;
   TLabel *KeyStrokeCode;
   TLabel *KeyName;
   TBitBtn *CancelBtn;
   TBitBtn *HelpBtn;
   TButton *LoadBtn;
   TButton *SaveBtn;
   TOpenDialog *OpenDlg;
   TSaveDialog *SaveDlg;
   TGroupBox *KeyState;
   TRadioButton *UnShifted;
   TRadioButton *Shifted;
   TRadioButton *WithCtrl;
   TRadioButton *WithAlt;
   TEdit *HexEquivalent;
   TBitBtn *UpdateBtn;
   TLabel *Label4;
   TLabel *TableName;
   TLabel *HexPrefix1;
   TLabel *HexPrefix2;
   TLabel *HexPrefix3;
   TEdit *HexEquivalent2;
   TComboBox *DefaultTableList;
   TBevel *Bevel2;
   TLabel *Label5;
   void __fastcall FormCreate(TObject *Sender);
   void __fastcall BtnInvQuoteClick(TObject *Sender);
   void __fastcall PreDefinedCheckClick(TObject *Sender);
   void __fastcall UnShiftedClick(TObject *Sender);
   void __fastcall LiteralCheckClick(TObject *Sender);
   void __fastcall HexCheckClick(TObject *Sender);
   void __fastcall LoadBtnClick(TObject *Sender);
   void __fastcall SaveBtnClick(TObject *Sender);
   void __fastcall ShiftedClick(TObject *Sender);
   void __fastcall WithCtrlClick(TObject *Sender);
   void __fastcall WithAltClick(TObject *Sender);
   void __fastcall LiteralStringChange(TObject *Sender);
   void __fastcall AddEnterClick(TObject *Sender);
   void __fastcall FormShow(TObject *Sender);
   void __fastcall PreDefinedListChange(TObject *Sender);
   void __fastcall LiteralStringKeyPress(TObject *Sender, char &Key);
   void __fastcall HexStringKeyPress(TObject *Sender, char &Key);
   void __fastcall UpdateBtnClick(TObject *Sender);
   void __fastcall FormDestroy(TObject *Sender);
   void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
   void __fastcall DefaultTableListClick(TObject *Sender);
   void __fastcall LiteralStringKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
   void __fastcall HexStringKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
private:	// User declarations
   KeyMap *_keyMap;
   unsigned char _key;
   unsigned int _toAdd;
   type_t _keyType;
   keyMap _currentKey;
   bool _showingPreDefined;
   bool _showingLiteral;
   bool _showingHex;
   bool _modified;
   void __fastcall HideFields(bool preDefined, bool literal, bool hex);
   void __fastcall DisplayKeyDetails(shiftState_t shift);
   void __fastcall EnableControls(bool enable);
   void __fastcall FocusKeyboard(void);
   void __fastcall FocusKeyState(void);
   void __fastcall FocusKeyAssignment(void);
public:		// User declarations
   __fastcall TKeyMapSetupForm(TComponent* Owner, KeyMap *keyMap);
};
//---------------------------------------------------------------------------
extern PACKAGE TKeyMapSetupForm *KeyMapSetupForm;
//---------------------------------------------------------------------------
#endif
