//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//###Change OpenDlg and SaveDlg to openDlg and SaveDlg
#include <vcl.h>
#pragma hdrstop

#include "TKeyMapSetupForm.h"
#include "strcommon.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "NewButton"
#pragma resource "*.dfm"
TKeyMapSetupForm *KeyMapSetupForm;
//---------------------------------------------------------------------------
__fastcall TKeyMapSetupForm::TKeyMapSetupForm(TComponent* Owner, KeyMap *keyMap)
   : TForm(Owner)
{
_keyMap = keyMap;
}
//---------------------------------------------------------------------------


void __fastcall TKeyMapSetupForm::FormCreate(TObject *Sender)
{
// Assign each Btn the correct keycode
BtnEsc->Tag = K_ESCAPE;
BtnF1->Tag = K_F1;
BtnF2->Tag = K_F2;
BtnF3->Tag = K_F3;
BtnF4->Tag = K_F4;
BtnF5->Tag = K_F5;
BtnF6->Tag = K_F6;
BtnF7->Tag = K_F7;
BtnF8->Tag = K_F8;
BtnF9->Tag = K_F9;
BtnF10->Tag = K_F10;
BtnF11->Tag = K_F11;
BtnF12->Tag = K_F12;
BtnInvQuote->Tag = K_INVQUOTE;
Btn1->Tag = K_1;
Btn2->Tag = K_2;
Btn3->Tag = K_3;
Btn4->Tag = K_4;
Btn5->Tag = K_5;
Btn6->Tag = K_6;
Btn7->Tag = K_7;
Btn8->Tag = K_8;
Btn9->Tag = K_9;
Btn0->Tag = K_0;
BtnMinus->Tag = K_MINUS;
BtnEquals->Tag = K_EQUALS;
BtnBackSlash->Tag = K_BACKSLASH;
BtnBack->Tag = K_BACK;
BtnTab->Tag = K_TAB;
BtnQ->Tag = K_Q;
BtnW->Tag = K_W;
BtnE->Tag = K_E;
BtnR->Tag = K_R;
BtnT->Tag = K_T;
BtnY->Tag = K_Y;
BtnU->Tag = K_U;
BtnI->Tag = K_I;
BtnO->Tag = K_O;
BtnP->Tag = K_P;
BtnSquareLeft->Tag = K_SQUARELEFT;
BtnSquareRight->Tag = K_SQUARERIGHT;
//BtnCaps->Tag = ;
BtnA->Tag = K_A;
BtnS->Tag = K_S;
BtnD->Tag = K_D;
BtnF->Tag = K_F;
BtnG->Tag = K_G;
BtnH->Tag = K_H;
BtnJ->Tag = K_J;
BtnK->Tag = K_K;
BtnL->Tag = K_L;
BtnSemiColon->Tag = K_SEMICOLON;
BtnSingleQuote->Tag = K_SINGLEQUOTE;
BtnReturn->Tag = K_RETURN;
//BtnLeftShift->Tag = ;
BtnZ->Tag = K_Z;
BtnX->Tag = K_X;
BtnC->Tag = K_C;
BtnV->Tag = K_V;
BtnB->Tag = K_B;
BtnN->Tag = K_N;
BtnM->Tag = K_M;
BtnComma->Tag = K_COMMA;
BtnFullStop->Tag = K_FULLSTOP;
BtnForwardSlash->Tag = K_FORWARDSLASH;
//BtnRightShift->Tag = ;
//BtnLeftCtrl->Tag = ;
//BtnLeftAlt->Tag = ;
BtnSpace->Tag = K_SPACE;
//BtnRightAlt->Tag = ;
//BtnRightCtrl->Tag = ;
BtnInsert->Tag = K_INSERT;
BtnDelete->Tag = K_DELETE;
BtnHome->Tag = K_HOME;
BtnEnd->Tag = K_END;
BtnPrior->Tag = K_PRIOR;
BtnNext->Tag = K_NEXT;
BtnUp->Tag = K_UP;
BtnLeft->Tag = K_LEFT;
BtnDown->Tag = K_DOWN;
BtnRight->Tag = K_RIGHT;
//BtnNumLock->Tag = ;
BtnDivide->Tag = K_DIVIDE;
BtnMultiply->Tag = K_MULTIPLY;
BtnSubtract->Tag = K_SUBTRACT;
BtnAdd->Tag = K_ADD;
BtnNumpad0->Tag = K_NUMPAD0;
BtnNumpad1->Tag = K_NUMPAD1;
BtnNumpad2->Tag = K_NUMPAD2;
BtnNumpad3->Tag = K_NUMPAD3;
BtnNumpad4->Tag = K_NUMPAD4;
BtnNumpad5->Tag = K_NUMPAD5;
BtnNumpad6->Tag = K_NUMPAD6;
BtnNumpad7->Tag = K_NUMPAD7;
BtnNumpad8->Tag = K_NUMPAD8;
BtnNumpad9->Tag = K_NUMPAD9;
BtnEnter->Tag = K_RETURN;
BtnDecimal->Tag = K_DECIMAL;
// Setup the Pre-Defined keys list box
char name[MAX_PNAME+1] = "";
// Write each of the predefined keys into the PreDefined list box
for (int i=1; i<PREMAP_SIZE; i++)
   {
   _keyMap->getPreMapName(i, name);
   PreDefinedList->Items->Add(name);
   }
// Setup the Default-Table list box
//###Change this later to the new combo box
DefaultTableList->Items->AddObject("EMU Default", (TObject *)DT_EMU);
DefaultTableList->Items->AddObject("Matching Bank1", (TObject *)DT_BANK1);
DefaultTableList->Items->AddObject("Matching Bank 2", (TObject *)DT_BANK2);
DefaultTableList->Items->AddObject("Niakwa", (TObject *)DT_NIAKWA);
DefaultTableList->Items->AddObject("PC Equivalent", (TObject *)DT_PC);
_showingPreDefined = true;
_showingLiteral = true;
_showingHex = true;
_modified = false;
_currentKey.name[0] = '\0';
_currentKey.code = new unsigned char[MAX_CODE];
_currentKey.type = MT_STRING;
_currentKey.codeLength = 0;
_currentKey.preMapIndex = -1;
LiteralString->MaxLength = MAX_CODE;
HexString->MaxLength = MAX_CODE*2;
OpenDlg->InitialDir = ExtractFilePath(Application->ExeName);
SaveDlg->InitialDir = ExtractFilePath(Application->ExeName);
}
//---------------------------------------------------------------------------

void __fastcall TKeyMapSetupForm::BtnInvQuoteClick(TObject *Sender)
{
// Obtain the key code from the button that was clicked
if (!dynamic_cast<TNewButton *>(Sender))
   {
   return;
   };
_key = dynamic_cast<TNewButton *>(Sender)->Tag;
dynamic_cast<TNewButton *>(Sender)->Down = true;
// Enable the controls
FocusKeyState();
KeyState->SetFocus();
}

//---------------------------------------------------------------------------
void __fastcall TKeyMapSetupForm::HideFields(bool preDefined, bool literal, bool hex)
{
// Hides or shows the fields corresponding to the Key assingment type
if (preDefined && _showingPreDefined)
   {
   // Hide the pre-defined fields
   PreDefinedList->Visible = false;
   HexEquivalent2->Visible = false;
   HexPrefix3->Visible = false;
   _showingPreDefined = false;
   }
else if (!preDefined && !_showingPreDefined)
   {
   // Show the pre-defined fields
   PreDefinedList->Visible = true;
   HexEquivalent2->Visible = true;
   HexPrefix3->Visible = true;
   _showingPreDefined = true;
   }
if (literal && _showingLiteral)
   {
   // Hide the literal String fields
   LiteralString->Visible = false;
   HexEquivalent->Visible = false;
   HexPrefix1->Visible = false;
   AddEnter->Visible = false;
   _showingLiteral = false;
   }
else if (!literal && !_showingLiteral)
   {
   // Show the literal String fields
   LiteralString->Visible = true;
   HexEquivalent->Visible = true;
   HexPrefix1->Visible = true;
   AddEnter->Visible = true;
   _showingLiteral = true;
   }
if (hex && _showingHex)
   {
   // Hide the hex string fields
   HexString->Visible = false;
   HexPrefix2->Visible = false;
   _showingHex = false;
   }
else if (!hex && !_showingHex)
   {
   // Display the hex string fields
   HexString->Visible = true;
   HexPrefix2->Visible = true;
   _showingHex = true;
   }
}

//---------------------------------------------------------------------------
void __fastcall TKeyMapSetupForm::PreDefinedCheckClick(TObject *Sender)
{
// If PreDefined hasn't been checked before,
// then clear the other fields and select the first pre-defined key
HideFields(false, true, true);
// Clear the contents of the fields
if (_currentKey.type != MT_PREDEFINED)
   {
   PreDefinedList->ItemIndex = -1;
   HexEquivalent2->Text = "";
   }
PreDefinedList->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TKeyMapSetupForm::LiteralCheckClick(TObject *Sender)
{
HideFields(true, false, true);
// Clear the contents of the fields
if (_currentKey.type != MT_STRING)
   LiteralString->Text = "";
LiteralString->SetFocus();
}

//---------------------------------------------------------------------------
void __fastcall TKeyMapSetupForm::HexCheckClick(TObject *Sender)
{
HideFields(true, true, false);
// Clear the contents of the fields
if (_currentKey.type != MT_HEX)
   HexString->Text = "";
HexString->SetFocus();
}
//---------------------------------------------------------------------------

void __fastcall TKeyMapSetupForm::LoadBtnClick(TObject *Sender)
{
if (OpenDlg->Execute())
   {
   // Load the keyboard map file into memory
   string fileName = OpenDlg->FileName.c_str(); //t_str(); //) 

   _keyMap->loadSetup(fileName);
   _modified = false;
   FocusKeyboard();
   }
}
//---------------------------------------------------------------------------

void __fastcall TKeyMapSetupForm::SaveBtnClick(TObject *Sender)
{
string fileName;

_keyMap->getFileName(fileName);
// If the current filename is NOT a default table, then give the filename to
// the Save dialog box
if (fileName[0] != '<')
   SaveDlg->FileName = fileName.c_str();
if (SaveDlg->Execute())
   {
   // Write the current keyboard map in memory to the specified file
   string temp = SaveDlg->FileName.c_str(); //t_str();
   _keyMap->saveSetup(temp);
   _keyMap->getFileName(fileName);
   TableName->Caption = ExtractFileName(fileName.c_str());
   _modified = false;
   }
}
//---------------------------------------------------------------------------
void __fastcall TKeyMapSetupForm::DisplayKeyDetails(shiftState_t state)
{
// Check the assignment type from the KeyMap
_currentKey.codeLength = MAX_CODE;
_keyMap->getKeyName(_key, state, _currentKey.name);
_keyMap->getKeyCode(_key, state, _currentKey.code, _currentKey.codeLength);
_currentKey.type = _keyMap->getKeyType(_key, state);
_currentKey.preMapIndex = _keyMap->getKeyPreMapIndex(_key, state);
// Update the screen with the key details
KeyName->Caption = _currentKey.name;
if (state.alt)
   KeyStrokeCode->Caption = "\\x" + AnsiString().IntToHex(C_ALT | _key, 4);
else if (state.ctrl)
   KeyStrokeCode->Caption = "\\x" + AnsiString().IntToHex(C_CTRL | _key, 4);
else if (state.shift)
   KeyStrokeCode->Caption = "\\x" + AnsiString().IntToHex(C_SHIFT | _key, 4);
else
   KeyStrokeCode->Caption = "\\x" + AnsiString().IntToHex(C_UNSHIFT | _key, 4);
if (_currentKey.type == MT_PREDEFINED)
   {
   char hexString[MAX_PCODE*2+1] = "";   // Double the size of the hex field
   int length = _currentKey.codeLength;

   HideFields(false, true, true);
   PreDefinedCheck->Checked = true;
   PreDefinedList->ItemIndex = _currentKey.preMapIndex-1;
   hexBufToStr(_currentKey.code, hexString, length);
   hexString[length] = '\0';
   HexEquivalent2->Text = hexString;
   PreDefinedList->SetFocus();
   }
else if (_currentKey.type == MT_STRING)
   {
   HideFields(true, false, true);
   LiteralCheck->Checked = true;

   if (_currentKey.code[_currentKey.codeLength-1] == (unsigned char)0x0D)
      {
      _currentKey.code[_currentKey.codeLength-1] = '\0';
      AddEnter->Checked = true;
      }
   else
      {
      _currentKey.code[_currentKey.codeLength] = '\0';
      AddEnter->Checked = false;
      }
   LiteralString->Text = (char *)_currentKey.code;
   LiteralString->SetFocus();
   }
else if (_currentKey.type == MT_HEX)
   {
   char hexString[MAX_CODE*2+1] = "";   // Double the size of the hex field
   int length = _currentKey.codeLength;

   HideFields(true, true, false);
   HexCheck->Checked = true;
   hexBufToStr(_currentKey.code, hexString, length);
   hexString[length] = '\0';
   HexString->Text = hexString;
   HexString->SetFocus();
   }
}

//---------------------------------------------------------------------------
void __fastcall TKeyMapSetupForm::UnShiftedClick(TObject *Sender)
{
shiftState_t state;

FocusKeyAssignment();
state.shift = false;
state.ctrl = false;
state.alt = false;
_toAdd = C_UNSHIFT;
DisplayKeyDetails(state);
}

//---------------------------------------------------------------------------
void __fastcall TKeyMapSetupForm::ShiftedClick(TObject *Sender)
{
//
shiftState_t state;

FocusKeyAssignment();
state.shift = true;
state.ctrl = false;
state.alt = false;
_toAdd = C_SHIFT;
DisplayKeyDetails(state);
}

//---------------------------------------------------------------------------

void __fastcall TKeyMapSetupForm::WithCtrlClick(TObject *Sender)
{
//
shiftState_t state;

FocusKeyAssignment();
state.shift = false;
state.ctrl = true;
state.alt = false;
_toAdd = C_CTRL;
DisplayKeyDetails(state);
}
//---------------------------------------------------------------------------

void __fastcall TKeyMapSetupForm::WithAltClick(TObject *Sender)
{
//
shiftState_t state;

FocusKeyAssignment();
state.shift = false;
state.ctrl = false;
state.alt = true;
_toAdd = C_ALT;
DisplayKeyDetails(state);
}
//---------------------------------------------------------------------------

void __fastcall TKeyMapSetupForm::LiteralStringChange(TObject *Sender)
{
// Convert the text to hex codes and display in the Hex Equivalent edit field
char hexString[MAX_CODE*2+1] = "";
int length = LiteralString->Text.Length();

hexBufToStr((unsigned char *)(LiteralString->Text.c_str()), hexString, length);
hexString[length] = '\0';
HexEquivalent->Text = hexString;
}
//---------------------------------------------------------------------------

void __fastcall TKeyMapSetupForm::AddEnterClick(TObject *Sender)
{
// Append a Hex(0D) to the end of the string
/*if (AddEnter->Checked)
   LiteralString->Text = LiteralString->Text + "\x0D";
else
   {
   unsigned int length = LiteralString->Text.Length();
   if (LiteralString->Text[length] == '\x0D')
      LiteralString->Text = LiteralString->Text.SubString(1, length-1); // Terminate the string
   }
*/
}
//---------------------------------------------------------------------------
void __fastcall TKeyMapSetupForm::FormShow(TObject *Sender)
{
string fileName;
_keyMap->getFileName(fileName);
TableName->Caption = ExtractFileName(fileName.c_str());
FocusKeyboard();
}
//---------------------------------------------------------------------------
void __fastcall TKeyMapSetupForm::PreDefinedListChange(TObject *Sender)
{
char hexString[MAX_PCODE*2+1] = "";
unsigned char code[MAX_PCODE] = "";
int length = MAX_PCODE;

//_modified = true;
_keyMap->getPreMapCode(PreDefinedList->ItemIndex+1, code, length);
hexBufToStr(code, hexString, length);
hexString[length] = '\0';
HexEquivalent2->Text = hexString;
// Enabled the Update button
if (!UpdateBtn->Enabled)
   UpdateBtn->Enabled = true;
}
//---------------------------------------------------------------------------

void __fastcall TKeyMapSetupForm::LiteralStringKeyPress(TObject *Sender,
      char &Key)
{
//_modified = true;
// Enabled the Update button
if (!UpdateBtn->Enabled)
   UpdateBtn->Enabled = true;
}
//---------------------------------------------------------------------------

void __fastcall TKeyMapSetupForm::HexStringKeyPress(TObject *Sender,
      char &Key)
{
switch (Key)
   {
   case '0':
   case '1':
   case '2':
   case '3':
   case '4':
   case '5':
   case '6':
   case '7':
   case '8':
   case '9':
   case 'a':
   case 'A':
   case 'b':
   case 'B':
   case 'c':
   case 'C':
   case 'd':
   case 'D':
   case 'e':
   case 'E':
   case 'f':
   case 'F':
   case '\x08':   // Allow backspace
      //_modified = true;
      // Enabled the Update button
      if (!UpdateBtn->Enabled)
         UpdateBtn->Enabled = true;
   break;
   default :
      Key = 0;
   break;
   }
}
//---------------------------------------------------------------------------


void __fastcall TKeyMapSetupForm::UpdateBtnClick(TObject *Sender)
{
// Save the current key settings to the keyboard map
unsigned char tempCode[MAX_CODE*2+1] = "";
int length;

if (PreDefinedCheck->Checked)
   {
   char name[MAX_PNAME+1] = "";
   // Map the key to a predefined key
   _currentKey.preMapIndex = PreDefinedList->ItemIndex+1;
   _keyMap->getPreMapName(_currentKey.preMapIndex, name);
   _keyMap->assignKey(_key | _toAdd, name, MT_PREDEFINED);
   }
else if (LiteralCheck->Checked)
   {
   // Map the key to a Literal String
   length = min(MAX_CODE, LiteralString->Text.Length());
   memcpy(tempCode, LiteralString->Text.c_str(), length);
   if (AddEnter->Checked)
      {
      // Ensure we don't step outside the boundry of the code length
      if (length == MAX_CODE)
         {
         tempCode[length-1] = (unsigned char)0x0D;
         tempCode[length] = '\0';
         }
      else
         {
         tempCode[length] = (unsigned char)0x0D;
         tempCode[length+1] = '\0';
         }
      }
   _keyMap->assignKey(_key | _toAdd, tempCode, MT_STRING);
   }
else if (HexCheck->Checked)
   {
   // Map the key to a hex string
   length = min(MAX_CODE*2, HexString->Text.Length());
   memcpy(tempCode, HexString->Text.c_str(), length);
   tempCode[length] = '\0';
   _keyMap->assignKey(_key | _toAdd, tempCode, MT_HEX);
   }
_modified = true;
UpdateBtn->Enabled = false;
}

void __fastcall TKeyMapSetupForm::FocusKeyboard(void)
{
string fileName;
UnShifted->Checked = false;
Shifted->Checked = false;
WithAlt->Checked = false;
WithCtrl->Checked = false;
UnShifted->Enabled = false;
Shifted->Enabled = false;
WithAlt->Enabled = false;
WithCtrl->Enabled = false;
KeyName->Caption = "";
KeyStrokeCode->Caption = "";
PreDefinedCheck->Checked = false;
LiteralCheck->Checked = false;
HexCheck->Checked = false;
PreDefinedCheck->Enabled = false;
LiteralCheck->Enabled = false;
HexCheck->Enabled = false;
UpdateBtn->Enabled = false;
_keyMap->getFileName(fileName);
TableName->Caption = ExtractFileName(fileName.c_str());
HideFields(true, true, true);
KeyBoard->SetFocus();
// Cycle through each of the buttons and ensure they're popped up!
TComponent *temp;
for (int i=this->ComponentCount-1; i >= 0; i--)
   {
   temp = this->Components[i];
    // only move components that are not controls
    if (dynamic_cast<TNewButton *>(temp))
      {
      dynamic_cast<TNewButton *>(temp)->Down = false;
      }
  }
}

void __fastcall TKeyMapSetupForm::FocusKeyState(void)
{
UnShifted->Enabled = true;
Shifted->Enabled = true;
WithAlt->Enabled = true;
WithCtrl->Enabled = true;
UnShifted->Checked = false;
Shifted->Checked = false;
WithAlt->Checked = false;
WithCtrl->Checked = false;
KeyName->Caption = "";
KeyStrokeCode->Caption = "";
PreDefinedCheck->Checked = false;
LiteralCheck->Checked = false;
HexCheck->Checked = false;
PreDefinedCheck->Enabled = false;
LiteralCheck->Enabled = false;
HexCheck->Enabled = false;
UpdateBtn->Enabled = false;
HideFields(true, true, true);
}
//---------------------------------------------------------------------------
void __fastcall TKeyMapSetupForm::FocusKeyAssignment(void)
{
PreDefinedCheck->Enabled = true;
LiteralCheck->Enabled = true;
HexCheck->Enabled = true;
UnShifted->Enabled = false;
Shifted->Enabled = false;
WithAlt->Enabled = false;
WithCtrl->Enabled = false;
UpdateBtn->Enabled = false;
HideFields(true, true, true);
}

void __fastcall TKeyMapSetupForm::FormDestroy(TObject *Sender)
{
delete [] _currentKey.code;
}
//---------------------------------------------------------------------------


void __fastcall TKeyMapSetupForm::FormClose(TObject *Sender,
      TCloseAction &Action)
{
if (_modified)
   {
   // Tell the user that the keyboard mapping has been changed
   int result = MessageDlg("The current Keyboard Mapping has not been saved to \
DISK!\n\nDo you want to save to a file now?", mtWarning, TMsgDlgButtons() << mbYes << mbNo, 0);
   if (result == mrYes)
      {
      // Don't close the window and display the Save Dislog box
      SaveBtn->Click();
      Action = caNone;
      }
   else
      {
      Action = caHide;
      }
   }
}
//---------------------------------------------------------------------------

void __fastcall TKeyMapSetupForm::DefaultTableListClick(TObject *Sender)
{
// Ask the user if they REALLY want to load one of the default keyboard tables
int result = MessageDlg("This will clear the current keyboard table and load the selected default key mapping.\n\n\
All current Keyboard mappings will be lost!\n\nAre you sure you sure you want to continue?", mtConfirmation, TMsgDlgButtons() << mbYes << mbNo, 0);
if (result == mrYes)
   {
   // Load the selected default keyboard table
   default_t toLoad = (default_t)DefaultTableList->Items->Objects[DefaultTableList->ItemIndex];
   _keyMap->loadDefault(toLoad);
   FocusKeyboard();
   // Make the user save a default keyboard table if they wish it to be loaded on startup
   _modified = true;
   }
DefaultTableList->ItemIndex = -1;
}
//---------------------------------------------------------------------------

void __fastcall TKeyMapSetupForm::LiteralStringKeyDown(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
if (Key == VK_DELETE)
   {
   // Enabled the Update button
   if (!UpdateBtn->Enabled)
      UpdateBtn->Enabled = true;
   }
}
//---------------------------------------------------------------------------

void __fastcall TKeyMapSetupForm::HexStringKeyDown(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
if (Key == VK_DELETE)
   {
   // Enabled the Update button
   if (!UpdateBtn->Enabled)
      UpdateBtn->Enabled = true;
   }
}
//---------------------------------------------------------------------------


