//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TComSetupForm.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "CPortCtl"
#pragma link "TSetupForm"
#pragma resource "*.dfm"
TComSetupForm *ComSetupForm;
//---------------------------------------------------------------------------
__fastcall TComSetupForm::TComSetupForm(TComponent* Owner, TComPort *comPort,
   WinCommInterface *comInterface)
: TSetupForm(Owner)
{
   _comInterface = comInterface;
   _comPort = comPort;
   portCombo->ComPort = _comPort;
   baudCombo->ComPort = _comPort;
   dataCombo->ComPort = _comPort;
   stopCombo->ComPort = _comPort;
   parityCombo->ComPort = _comPort;
   switch (_comPort->FlowControl->FlowControl)
   {
      case fcHardware :
         cboFlowControl->ItemIndex = 0;
      break;
      case fcSoftware :
         cboFlowControl->ItemIndex = 1;
      break;
      default :
         cboFlowControl->ItemIndex = 2;
      break;
   }
   cboFlowControl->ItemIndex = (int)_comPort->FlowControl->FlowControl;
}
//---------------------------------------------------------------------------

void __fastcall TComSetupForm::defaultBtnClick(TObject *Sender)
{
   // Set the default comport settings
   _comInterface->setDefaults();
   baudCombo->UpdateSettings();
   dataCombo->UpdateSettings();
   stopCombo->UpdateSettings();
   parityCombo->UpdateSettings();
   cboFlowControl->ItemIndex = 2;
}
//---------------------------------------------------------------------------
void __fastcall TComSetupForm::applyBtnClick(TObject *Sender)
{
   // Apply the settings made to the comport variable
   _comPort->BeginUpdate();
   try
   {
      portCombo->ApplySettings();
      baudCombo->ApplySettings();
      dataCombo->ApplySettings();
      stopCombo->ApplySettings();
      parityCombo->ApplySettings();
      _comPort->FlowControl->FlowControl = (TFlowControl)cboFlowControl->ItemIndex;
   }
   catch(...)
   {
      _comPort->EndUpdate();
      throw;
   }
   _comPort->EndUpdate();
}
//---------------------------------------------------------------------------

