//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TAsciiDumpForm.h"
#include <iniFiles.hpp>
#include <memory>
#include <winbase.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
//---------------------------------------------------------------------------
#define SECTION "ASCII Transfer"
#define DEF_START_NUM 1
#define DEF_NO_LINE_NUMS false
#define DEF_PAUSE_TIME 10
#define DEF_BLOCK_SIZE 50
#define DEF_PRE_TEXT "DATA \""
#define DEF_POST_TEXT "\""
#define DEF_FINAL_TEXT "LOAD RUN T \"START\""

TfrmAsciiDump *frmAsciiDump;

//---------------------------------------------------------------------------
__fastcall TfrmAsciiDump::TfrmAsciiDump(TComponent* Owner)
   : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TfrmAsciiDump::ReadSettings()
{
   std::auto_ptr<TIniFile> iniFile (new TIniFile(_iniFile));

   _startNum = iniFile->ReadInteger(SECTION, "Start Num", DEF_START_NUM);
   _noLineNums = iniFile->ReadBool(SECTION, "No Line Numbers", DEF_NO_LINE_NUMS);
   _inFileName = iniFile->ReadString(SECTION, "In FileName", "");
   _pauseTime = iniFile->ReadInteger(SECTION, "Pause Time", DEF_PAUSE_TIME);
   if (_pauseTime < 0)
      _pauseTime = DEF_PAUSE_TIME;
   _blockSize = iniFile->ReadInteger(SECTION, "Block Size", DEF_BLOCK_SIZE);
   if (_blockSize <= 0)
      _blockSize = DEF_BLOCK_SIZE;
   _preText = iniFile->ReadString(SECTION, "Pre Text", DEF_PRE_TEXT);
   _postText = iniFile->ReadString(SECTION, "Post Text", DEF_POST_TEXT);
   _finalLineText = iniFile->ReadString(SECTION, "Final Line Text", DEF_FINAL_TEXT);
}

void __fastcall TfrmAsciiDump::WriteSettings()
{
   std::auto_ptr<TIniFile> iniFile (new TIniFile(_iniFile));

   iniFile->WriteInteger(SECTION, "Start Num", _startNum);
   iniFile->WriteBool(SECTION, "No Line Numbers", _noLineNums);
   iniFile->WriteString(SECTION, "In FileName", _inFileName);
   iniFile->WriteInteger(SECTION, "Pause Time", _pauseTime);
   iniFile->WriteInteger(SECTION, "Block Size", _blockSize);
   iniFile->WriteString(SECTION, "Pre Text", _preText);
   iniFile->WriteString(SECTION, "Post Text", _postText);
   iniFile->WriteString(SECTION, "Final Line Text", _finalLineText);
}

void __fastcall TfrmAsciiDump::UpdateDisplay()
{
   edtStartNum->Text = IntToStr(_startNum);
   chkNoLineNums->Checked = _noLineNums;
   edtInFileName->Text = _inFileName;
   edtPauseTime->Text = IntToStr(_pauseTime);
   edtBlockSize->Text = IntToStr(_blockSize);
   edtPreText->Text = _preText;
   edtPostText->Text = _postText;
   edtFinalLineText->Text = _finalLineText;
}

void __fastcall TfrmAsciiDump::ReadDisplay()
{
   if (edtStartNum->Text == "")
      edtStartNum->Text = IntToStr(DEF_START_NUM);
   if (edtPauseTime->Text == "")
      edtPauseTime->Text = IntToStr(DEF_PAUSE_TIME);
   if (edtBlockSize->Text == "")
      edtBlockSize->Text = IntToStr(DEF_BLOCK_SIZE);
   _startNum = StrToInt(edtStartNum->Text);
   _noLineNums = chkNoLineNums->Checked;
   _inFileName = edtInFileName->Text;
   _pauseTime = StrToInt(edtPauseTime->Text);
   _blockSize = StrToInt(edtBlockSize->Text);
   _preText = edtPreText->Text;
   _postText = edtPostText->Text;
   _finalLineText = edtFinalLineText->Text;
}

void __fastcall TfrmAsciiDump::btnInBrowseClick(TObject *Sender)
{
   if (dlgOpen->Execute())
   {
      edtInFileName->Text = dlgOpen->FileName;
   }
}
//---------------------------------------------------------------------------

void __fastcall TfrmAsciiDump::btnTransferClick(TObject *Sender)
{
   try
   {
      Enabled = false;
      if (_commInterface == 0)
         return;

      ReadDisplay();

      if (!FileExists(_inFileName))
      {
         MessageDlg("Input file does NOT exist. Aborting File Transfer!", mtError, TMsgDlgButtons() << mbOK, 0);
         Enabled = true;
         return;
      }

      std::auto_ptr<TStringList> inList (new TStringList());
      inList->LoadFromFile(_inFileName);
      Progress->Position = 0;
      Progress->Max = inList->Count;
      AnsiString tmpStr("");
      AnsiString partStr("");
      int blockCnt = 0;
      for (int i=0,j=_startNum; i<inList->Count; i++, j++)
      {
         if (inList->Strings[i] == "")
            continue;
         if (_noLineNums)
            tmpStr = _preText + inList->Strings[i] + _postText + '\r';
         else
            tmpStr = IntToStr(j) + " " + _preText + inList->Strings[i] + _postText + '\r';

         // Break up the line into the specified block size
         blockCnt = tmpStr.Length() / _blockSize;
         if ((tmpStr.Length() % _blockSize) > 0)
            blockCnt++;
         for (int k=0; k < blockCnt; k++)
         {
            partStr = tmpStr.SubString((k * _blockSize) + 1, _blockSize);
            _commInterface->write(partStr.c_str(), partStr.Length());
            Sleep(_pauseTime);
         }
         Progress->Position = i+1;
         Application->ProcessMessages();
      }

      // Output the final line
      if (_finalLineText != "")
      {
         tmpStr = _finalLineText + '\r';
         _commInterface->write(tmpStr.c_str(), tmpStr.Length());
      }

      MessageDlg("ASCII File Transfer Complete", mtInformation, TMsgDlgButtons() << mbOK, 0);
      Enabled = true;
      Close();
   }
   catch (...)
   {
      Enabled = true;
      throw;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmAsciiDump::edtNumsOnly(TObject *Sender,
      char &Key)
{
   switch (Key)
   {
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
      case '\x08':
         break;
      default :
         Key = '\0';
      break;
   }
}
//---------------------------------------------------------------------------
void TfrmAsciiDump::setCommInterface(CommInterface *commInterface)
{
   if (commInterface != NULL)
   {
      _commInterface = commInterface;
   }
}

void TfrmAsciiDump::setIniName(AnsiString* iniFile)
{
   _iniFile = *iniFile;
}
//---------------------------------------------------------------------------

void __fastcall TfrmAsciiDump::btnCloseClick(TObject *Sender)
{
   Close();
}
//---------------------------------------------------------------------------

void __fastcall TfrmAsciiDump::FormShow(TObject *Sender)
{
   UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TfrmAsciiDump::FormClose(TObject *Sender,
      TCloseAction &Action)
{
   ReadDisplay();
   WriteSettings();
}
//---------------------------------------------------------------------------

void __fastcall TfrmAsciiDump::FormKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   if (Key == VK_F2)
      btnTransfer->Click();
   else if (Key == VK_F10)
      btnClose->Click();
}
//---------------------------------------------------------------------------

