//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "AutoDialForm.h"
#include <iniFiles.hpp>
#include <memory>

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TSetupForm"
#pragma resource "*.dfm"

#define SECTION "Auto-Dial"

TfrmAutoDial *frmAutoDial;
//---------------------------------------------------------------------------
__fastcall TfrmAutoDial::TfrmAutoDial(TComponent* Owner)
   : TSetupForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TfrmAutoDial::ReadSettings()
{
   std::auto_ptr<TIniFile> iniFile (new TIniFile(_iniFile));

   chkDialOnStart->Checked = iniFile->ReadBool(SECTION, "DialOnStartup", false);
   chkDialNow->Checked = iniFile->ReadBool(SECTION, "DialNow", false);
   edtPhoneNum->Text = iniFile->ReadString(SECTION, "PhoneNumber", "");
}

void __fastcall TfrmAutoDial::WriteSettings()
{
   std::auto_ptr<TIniFile> iniFile (new TIniFile(_iniFile));

   iniFile->WriteBool(SECTION, "DialOnStartup", chkDialOnStart->Checked);
   iniFile->WriteBool(SECTION, "DialNow", chkDialNow->Checked);
   iniFile->WriteString(SECTION, "PhoneNumber", edtPhoneNum->Text);
}

void TfrmAutoDial::setIniName(AnsiString* iniFile)
{
   _iniFile = *iniFile;
}
void __fastcall TfrmAutoDial::applyBtnClick(TObject *Sender)
{
   WriteSettings();
}
//---------------------------------------------------------------------------
