//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#ifndef SetupInterfaceH
#define SetupInterfaceH
//---------------------------------------------------------------------------
// File: SetupInterface.h
// Desc.: Base class for the Setup class
//
//---------------------------------------------------------------------------
// Created: 03/01/2002
// Version History:
//    03/01/2002, 0.0.0 - First Implementation
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Required CUSTOM header files
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Required SYSTEM header files
//---------------------------------------------------------------------------
#include <stdlib.h>
#include <fstream.h>
#include <string.h>
#include <string>
//---------------------------------------------------------------------------
// --== Macros and constants ==--
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// --== DECLARATIONS ==--
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// --== Supporting Functions ==--
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Class: SetupInterface
// Desc.: Base class for storing setup options
//---------------------------------------------------------------------------
class SetupInterface
{
public:
   // Display the Setup Screen
   virtual int setup(void)=0;
   virtual bool loadSetup(const string &fileName)=0;
   virtual bool saveSetup(const string &fileName)=0;
};

//---------------------------------------------------------------------------
// Class: MainSetupInterface
// Desc.: Base class for storing the Main setup options in the Emu program
//---------------------------------------------------------------------------

enum WangFlowCtrl_t {
   wfcForce = 0,         // Forces the program to stop flow of data whilst processing incoming buffer
   wfcDynamic = 1,       // Only stops flow of data when buffer gets to 80% full
   wfcNone = 2           // No flow control used.
   };

class MainSetupInterface : public SetupInterface
{
protected:
   bool _openOnStart;
   bool _confirmExit;
   bool _capsOnStart;
   bool _capsOnFocus;
   bool _loggingOn;
   WangFlowCtrl_t _wangFlowCtrl;
   string _keyMapFile;
public:
   MainSetupInterface();
   bool openOnStart() {return (_openOnStart);}
   bool confirmExit() {return (_confirmExit);}
   bool capsOnStart() {return (_capsOnStart);}
   bool capsOnFocus() {return (_capsOnFocus);}
   bool loggingOn() {return (_loggingOn);}
   WangFlowCtrl_t wangFlowCtrl() {return (_wangFlowCtrl);}
   void setWangFlowCtrl(WangFlowCtrl_t fc) {_wangFlowCtrl = fc;}
   void keyMapFile(string &fileName) {fileName = _keyMapFile;}
   // Display the Setup Screen
   virtual int setup()=0;
   virtual bool loadSetup(const string &fileName)=0;
   virtual bool saveSetup(const string &fileName)=0;
};

#endif

//---------------------------------------------------------------------------
// END OF FILE
//---------------------------------------------------------------------------