//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#ifndef ScreenInterfaceH
#define ScreenInterfaceH
//---------------------------------------------------------------------------
// File: ScreenInterface.h
// Desc.: Header file for the basic ScreenInterface class
// Notes:
//---------------------------------------------------------------------------
// TODO:
//    - 
//---------------------------------------------------------------------------
// Version History:
//    19/08/2001, 0.0.0, Mark Pickersgill
//       - Created the file with the outline of each class
//    27/01/2002, 0.0.1, Mark Pickersgill
//       - Added font name storage and calculation, as this will
//       be the same across platforms.
//    16/02/2002, 0.0.2, Mark Pickersgill
//       - Changed enums initialized with character constants to
//       being initialized with hex constants.
//       - Removed set/getScreenType from class
//       - Changed variable and method names to conform to coding standard
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Required CUSTOM header files
//---------------------------------------------------------------------------
#include "ScreenBuffer.h"
#include "FiceFont.h"
//---------------------------------------------------------------------------
// Required SYSTEM header files
//---------------------------------------------------------------------------
#include <fstream.h>
#include <string.h>
#include <string>

using namespace std;

//---------------------------------------------------------------------------
// Macros and constants
//---------------------------------------------------------------------------
#define MAX_FONT_NAME 16   // Maximum size of a font name
#define MAX_COLOURS 16     // Maximum number of colours allowed
//---------------------------------------------------------------------------
// --== DECLARATIONS ==--
//---------------------------------------------------------------------------

// Constants for the colour control
enum c_control_t {CC_NORMAL_BACK=0x00, CC_REVERSE=0x01,
   CC_NORMAL_FORE=0x02, CC_UNDERLINE=0x03, CC_ALT_FORE1=0x04,
   CC_REV_UNDERLINE=0x05, CC_ALT_FORE2=0x06, CC_BRIGHT=0x07,
   CC_ALT_FORE3=0x08, CC_BRIGHT_BLINK=0x09, CC_ALT_BACK1=0x0A,
   CC_BLANK=0x0B, CC_ALT_BACK2=0x0C, CC_ALT_BACK3=0x0D, CC_BOX_LINE=0x0E,
   CC_BLINK=0x0F};

// General attribute type
struct attrib_t
   {
   attrib1_t Attrib1;
   attrib2_t Attrib2;
   };

// Direction in which to move the text cursor
enum direction_t {DIR_LEFT, DIR_RIGHT, DIR_UP, DIR_DOWN, DIR_HOME,
               DIR_END, DIR_TOP_HOME, DIR_BOTTOM_END };

//---------------------------------------------------------------------------
// Supporting Functions
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Class: ScreenInterface
// Desc.: Base Screen Interface from which other classes derive from
//---------------------------------------------------------------------------
class ScreenInterface : protected ScreenBuffer
{
private:
   int _currentX;
   int _currentY;
   int _statusX;
   bool _caretOn;
   bool _realUnderline;
   bool _realReverse;
   bool _realBright;
   bool _realBlink;
   bool _drawBoxLines;
   FiceFont _ficeFont;
   charSet_t _currentCharSet;
   colour_t _curColours[MAX_COLOURS];
   colour_t _defColours[MAX_COLOURS];
   attrib_t _currentAttribs;
   attrib_t _storedAttribs;
   attrib_t _statusAttribs;
   void initVariables(void);
   void chooseCharAttribs(const char character, charAttribs_t &char_attribs);
public:
   ScreenInterface();
   ScreenInterface(const int width, const int height);
   ScreenInterface(const int width, const int height, const colour_t fore, const colour_t back);
   virtual inline void setCaretOn(const bool state);
   virtual inline bool getCaretOn() const;
   virtual bool clearScreen();
   virtual void initScreen();
   virtual bool moveCaret(const direction_t direction, const int count=1);
   virtual void setColour(c_control_t c_control, colour_t colour);
   virtual colour_t getColour(c_control_t c_control);
   virtual void setDefColour(c_control_t c_control, colour_t colour);
   virtual colour_t getDefColour(c_control_t c_control);
   virtual void defColoursToCur();
   inline int getx() {return _currentX;}
   inline int gety() {return _currentY;}
   virtual inline void setStoredAttribs(const attrib_t &attribute);
   virtual inline void getStoredAttribs(attrib_t &attribute) const;
   virtual void toggleAttribs(bool on);
   virtual void putChar(char character);
   virtual void scrollDown(int lines=1);
   virtual void setCharSet(charSet_t char_set);
   virtual charSet_t getCharSet();
   virtual void setRealUnderline(bool on);
   virtual void setRealReverse(bool on);
   virtual void setRealBright(bool on);
   virtual void setRealBlink(bool on);
   virtual void setDrawBoxLines(bool on);
   virtual bool getRealUnderline();
   virtual bool getRealReverse();
   virtual bool getRealBright();
   virtual bool getRealBlink();
   virtual bool getDrawBoxLines();
   virtual void clearStatusLine();
   virtual void setStatusLineAttribs(attrib_t attribs);
   virtual bool writeStatusLine(char character, bool scroll);
   virtual void finishStatusLine();
   virtual language_t getLanguage();
   virtual void beep()=0;
   virtual string getNormalFontName() const;
   virtual string getNormalFontName2() const;
   virtual string getAlt0FontName() const;
   virtual string getAlt1FontName() const;
   virtual string getAlt2FontName() const;
   virtual void calcFontNames(language_t language, int resX, int resY,
      int screenX, int screenY);
   virtual int setup()=0;
   virtual bool loadSetup(const string &fileName)=0;
   virtual bool saveSetup(const string &fileName)=0;
   virtual void redraw();
   virtual void beginDrawBox()=0;
   virtual void endDrawBox()=0;
   virtual void drawTextLine(const direction_t direction, bool erase)=0;
   //###Possibly leave out ClearEol
//   virtual bool ClearEol(const int xpos, const int ypos);

   //Inherited routines that need to be declared as public
   //See base class ScreenBuffer for declarations
   ScreenBuffer::validPosition;
   ScreenBuffer::setDefAttribs;
   ScreenBuffer::getDefAttribs;
   ScreenBuffer::setWidth;
   ScreenBuffer::setHeight;
   ScreenBuffer::getWidth;
   ScreenBuffer::getHeight;
   ScreenBuffer::getCharAt;
   ScreenBuffer::getCharAt;   //###Check this multiple declaration...is it needed?
   ScreenBuffer::getAttributeAt;

};

#endif
//---------------------------------------------------------------------------
// END OF FILE
//---------------------------------------------------------------------------