//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#ifndef ScreenBufferH
#define ScreenBufferH
//---------------------------------------------------------------------------
// File: ScreenBuffer.h
// Desc.: Header file for the Basic Screen buffer class
// Notes:
//---------------------------------------------------------------------------
// TODO:
//    -
//---------------------------------------------------------------------------
// Version History:
//    06/07/2001, 0.0.0, Mark Pickersgill
//       - Created with basic implementation
//    09/07/2001, 0.0.1
//       - Removed DEF_ATTR macro and correctly initialised newly created
//       arrays.
//       - Fixed buffer index bug.
//       - Added 'CURRENT' constants to attribute and colour constants.
//    12/07/2001, 0.0.2
//       - Reworked the Default attribute handling.
//       - Added the TMWScreen class to add some windows specific functions.
//       - Added support for 'CURRENT' constants in the necessary methods.
//    16/07/2001, 0.0.3
//       - Added the ScreenInterface class to create a screen that acts like
//       the Fasstcom terminal.
//       - direction_t type added.
//       - Still some work to be done to make screen act correctly.
//    19/08/2001, 0.0.4
//       - Separated each class, so now ScreenBuffer remains in its own file
//       and is not specific to any type of screen
//    16/02/2002, 0.0.5
//       - Made the class store unsigned chars instead of straight chars.
//       - Converted enums set with character constants to hex constants.
//       - Changed variable names to conform to coding standard.
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Required CUSTOM header files
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Required SYSTEM header files
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Macros and constants
//---------------------------------------------------------------------------
#define SCR_MAX_BUFFER           4224
#define SCR_MAX_W                128
#define SCR_MAX_H                33
#define SCR_TINY_W               1
#define SCR_TINY_H               1
#define SCR_STD_W                80
#define SCR_STD_H                25
#define DEF_ATTR   (makeCharAttribs(IBM_DEFAULT_COLOUR,IBM_DEFAULT_COLOUR,ATTR_DEFAULT1,ATTR_DEFAULT2,CS_NORMAL,0))
#define DEF_CHAR              (unsigned char)0x20

//---------------------------------------------------------------------------
// --== DECLARATIONS ==--
//---------------------------------------------------------------------------
// Allowable Colours
enum colour_t {IBM_BLACK=0x00, IBM_BLUE=0x01, IBM_GREEN=0x02,
   IBM_CYAN=0x03, IBM_RED=0x04, IBM_MAGENTA=0x05, IBM_BROWN=0x06,
   IBM_LIGHTGRAY=0x07, IBM_DARKGRAY=0x08, IBM_LIGHTBLUE=0x09,
   IBM_LIGHTGREEN=0x0A, IBM_LIGHTCYAN=0x0B, IBM_LIGHTRED=0x0C,
   IBM_LIGHTMAGENTA=0x0D, IBM_YELLOW=0x0E, IBM_WHITE=0x0F,
   IBM_DEFAULT_COLOUR=0x99, IBM_CURRENT_COLOUR=0x9A };

// First part of a character's attributes
enum attrib1_t {ATTR_NORMAL1=0x00, ATTR_BRIGHT=0x02, ATTR_BLINK=0x04,
   ATTR_ALT_FORE1=0x06, ATTR_ALT_FORE2=0x08, ATTR_ALT_FORE3=0x0A,
   ATTR_BRIGHT_BLINK=0x0B, ATTR_DEFAULT1=0x99, ATTR_CURRENT1=0x9A };

// Second part of a character's attributes
enum attrib2_t {ATTR_NORMAL2=0x00, ATTR_REVERSE=0x02, ATTR_UNDERLINE=0x04,
   ATTR_ALT_BACK1=0x06, ATTR_ALT_BACK2=0x08, ATTR_ALT_BACK3=0x0A,
   ATTR_REV_UNDERLINE=0x0B, ATTR_DEFAULT2=0x99, ATTR_CURRENT2=0x9A };

// Character set to use
enum charSet_t {CS_NORMAL=0x00, CS_ALT1=0x01, CS_ALT2=0x02};

// Character attributes
struct charAttribs_t
    {
    colour_t ForeColour;
    colour_t BackColour;
    attrib1_t Attrib1;
    attrib2_t Attrib2;
    charSet_t CharSet;
    unsigned char Flags;
    };

//---------------------------------------------------------------------------
// Supporting Functions
//---------------------------------------------------------------------------
charAttribs_t makeCharAttribs(colour_t fore, colour_t back, attrib1_t attrib1,
   attrib2_t attrib2, charSet_t char_set, unsigned char flags);

//---------------------------------------------------------------------------
// Class: ScreenBuffer
// Desc.: Basic Screen Class to implement a basic screen buffer for reading
//       and writing to in a similar fashion to a real screen.
//---------------------------------------------------------------------------
class ScreenBuffer
{
private:
    int _screenHeight;
    int _screenWidth;
    // Private methods
    void initVariables(const int width, const int height, colour_t fore, colour_t back);
    void initCharArray(unsigned char *chararray, const unsigned char value, const int count);
    void initAttribsArray(charAttribs_t *attrarray, const charAttribs_t value, const int count);
protected:
    unsigned char *_characterArray;
    charAttribs_t *_attributeArray;
    charAttribs_t _defaultAttribs;
    inline void checkForDefault(charAttribs_t &attributes) const;
    inline void checkForCurrent(const int xpos, const int ypos, charAttribs_t &attributes) const;
public:
    ScreenBuffer();
    ScreenBuffer(const int width, const int height);
    ScreenBuffer(const int width, const int height, const colour_t fore, const colour_t back);
    virtual ~ScreenBuffer();
    virtual inline bool validPosition(const int xpos, const int ypos) const;
    virtual void setDefAttribs(const charAttribs_t &attributes);
    virtual inline void getDefAttribs(charAttribs_t &attributes) const;
    virtual void setWidth(const int width);
    virtual void setHeight(const int height);
    virtual inline int getWidth(void) const;
    virtual inline int getHeight(void) const;
    //Character and string handling
    virtual bool setCharAt(const int xpos, const int ypos, const unsigned char character);
    virtual bool setCharAt(const int xpos, const int ypos, const unsigned char character, const charAttribs_t &attribute);
    virtual unsigned char getCharAt(const int xpos, const int ypos) const;
    virtual unsigned char getCharAt(const int xpos, const int ypos, charAttribs_t &attribute) const;
    virtual bool fillCharRect(const int x1, const int y1, const int x2, const int y2, const unsigned char character);
    //Attribute handling
    virtual bool setFlagsAt(const int xpos, const int ypos, const unsigned char flags);
    virtual bool getFlagsAt(const int xpos, const int ypos, unsigned char &flags) const;
    //### Add an option to the Attribute setting to ignoreFlags=false and change the callers appropriately
    virtual bool setAttributeAt(const int xpos, const int ypos, const charAttribs_t &attribute);
    virtual bool getAttributeAt(const int xpos, const int ypos, charAttribs_t &attribute) const;
    virtual bool fillAttributeRect(const int x1, const int y1, const int x2, const int y2, const charAttribs_t &attribute);
};
#endif

//---------------------------------------------------------------------------
// END OF FILE
//---------------------------------------------------------------------------
