//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#ifndef PrinterInterfaceH
#define PrinterInterfaceH
//---------------------------------------------------------------------------
// File: PrinterInterface.h
// Desc.: Header file for the based class implementation of the 
//    PrinterInterface class.
//
//---------------------------------------------------------------------------
//  Created: 06/01/2002
//  Version History:
//    06/01/2002, 0.0.0 - Basic class outline
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Required CUSTOM header files
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Required SYSTEM header files
//---------------------------------------------------------------------------
#include <fstream.h>
#include <string>

//---------------------------------------------------------------------------
// --== DECLARATIONS ==--
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Class: PrinterInterface
// Desc.: Generic Printer Interface Class
//---------------------------------------------------------------------------
class PrinterInterface
{
public :
   PrinterInterface() {};
   // Adds a character to the internal filename to be printed to
   virtual void addToFileName(char letter)=0;
   // Sets the internal filename to the input filename
   virtual void setFileName(const string &newFileName)=0;
   virtual void print(const char letter)=0;
   // Switches from printing to the file back to the printer
   virtual void switchToPrinter(void)=0;
   virtual void switchToFile(void)=0;
//   virtual void flush(void)=0;
   virtual int setup(void)=0;
   virtual bool loadSetup(const string &fileName)=0;
   virtual bool saveSetup(const string &fileName)=0;

   // Closes the file opened previously and clears the filename
   virtual void close(void)=0;
};
#endif
//---------------------------------------------------------------------------
// END OF FILE
//---------------------------------------------------------------------------
