//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#ifndef FileInterfaceH
#define FileInterfaceH
//---------------------------------------------------------------------------
// File: FileInterface.h
// Desc.: Header file for the based class implementation of the 
//    FileInterface class.
//
//---------------------------------------------------------------------------
//  Created: 15/08/2001
//  Version History:
//    15/08/2001, 0.0.0 - Basic class outline
//    17/08/2001, 0.0.1 - Restructured files and made this file soley the
//                base class.
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Required CUSTOM header files
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Required SYSTEM header files
//---------------------------------------------------------------------------
#include <fstream.h>
#include <string>

//---------------------------------------------------------------------------
// --== DECLARATIONS ==--
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Class: FileInterface
// Desc.: Generic File Interface Class
//---------------------------------------------------------------------------
class FileInterface 
{
public :
   FileInterface() {};
   // Adds a character to the internal filename
   virtual void addToFileName(char letter)=0;
   // Sets the internal filename to the input filename
   virtual void setFileName(const string &newFileName)=0;
   // Creates a new file on the disk and overwrites the file if one exists.
   // Returns '0' on failure and '1' on success
   virtual char create(void)=0;
   // Checks to see if a file exists on the local disk
   // Returns '0' on failure and '1' on success
   virtual char exists(void)=0;
   // Opens the file for appending
   // Returns '0' on failure and '1' on success
   virtual char open(void)=0;
   // Writes data to the opened file. If the file is not open this method should
   // not fail.
   virtual void write(const char *dataBuffer, int size)=0;
   // Outputs a single character to the opened file. If the file is not open
   // this method should not fail.
   virtual void put(const char character)=0;
   // Flushes the data to disk
   virtual void flush(void)=0;
   // Closes the file opened previously and clears the filename
   virtual void close(void)=0;
};
#endif
//---------------------------------------------------------------------------
// END OF FILE
//---------------------------------------------------------------------------
