//---------------------------------------------------------------------------
// Copyright Mark Pickersgill 2001-2014
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#ifndef CommInterfaceH
#define CommInterfaceH
//---------------------------------------------------------------------------
// File: CommInterface.h
// Desc.: Base class for the Communications port class
//
//---------------------------------------------------------------------------
// Created: 17/09/2001
// Version History:
//    17/09/2001, 0.0.0 - First Implementation
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Required CUSTOM header files
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Required SYSTEM header files
//---------------------------------------------------------------------------
#include <stdlib.h>
#include <fstream.h>
#include <string.h>
#include <string>
//---------------------------------------------------------------------------
// --== Macros and constants ==--
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// --== DECLARATIONS ==-- 
//---------------------------------------------------------------------------
//### See if it's possible to remove the Borland specific __closure keyword!
typedef void (__closure *OnComReceive_t)(const int count);
typedef void (__closure *OnComOpen_t)(void);
typedef void (__closure *OnComClose_t)(void);
typedef void (__closure *OnCom80Full_t)(void);
//---------------------------------------------------------------------------
// --== Supporting Functions ==--
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Class: CommInterface
// Desc.: Base class for a Communications Port class
//---------------------------------------------------------------------------
class CommInterface
{
public:
   OnComReceive_t onComReceive;
   OnComOpen_t onComOpen;
   OnComClose_t onComClose;
   OnCom80Full_t onCom80Full;
   CommInterface();
   // Returns true if the Comm port is open, otherwise returns false
   virtual bool isOpen(void)=0;
   // Opens the Comm port
   virtual void open(void)=0;
   // Closes the Comm port
   virtual void close(void)=0;
   // Display the Setup Screen
   virtual int setup(void)=0;
   virtual bool loadSetup(const string &fileName)=0;
   virtual bool saveSetup(const string &fileName)=0;
   virtual int read(char *buffer, const int count)=0;
   virtual int write(char *buffer, const int count)=0;
   virtual void getSetupString(char *buffer)=0;
};
#endif

//---------------------------------------------------------------------------
// END OF FILE
//---------------------------------------------------------------------------